<?php

namespace App\Http\Controllers\Web;

use App\Conference;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;


class ConferenceController extends Controller
{
    private $view = 'web.conferences.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $conferences = Conference::withDescription([], 4);
        $title = __('conferences.latest_news');
        $firstEvent = $conferences->first();
       return view($this->view.'index', get_defined_vars());
    }

    public function show(Conference $conference)
    {
        $conference = Conference::withDescription([$conference->id]);
        $title = __('conferences.conference_details');
        return view($this->view.'show', get_defined_vars());

    }


    public function seeMore(Request $request)
    {
        if ($request->ajax()){
            $conferences = Conference::withDescription([], 4, $request->skip);
            $firstEventId = Conference::orderByDesc('id')->first()->id;
            return view($this->view.'see_more', get_defined_vars());
        }
    }
}
