<?php

namespace App\Http\Controllers\Web;

use App\Article;
use App\Conference;
use App\Doctor;
use App\Http\Controllers\Controller;
use App\Page;
use App\Partner;
use App\Service;
use App\Slider;
use App\WorkHour;
use Illuminate\View\View;


class HomeController extends Controller
{
    private $view = 'web.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $title = __('main.home');
        $sliders = Slider::withDescription();
        $ourPartnerTitle = explode(' ', __('partners.page_title'), 2);
        $ourPartnerTitle1 = $ourPartnerTitle[0];
        $ourPartnerTitle2 = $ourPartnerTitle[1];

        $partners = Partner::withDescription('partner');
        $services = Service::withDescription(null, 8, true)->toArray();

        $pages = Page::withDescription([4,5,6,16,17,18,19,20,24,25,26]);

        $whyUsCard1 = $pages[0];
        $whyUsCard2 = $pages[1];
        $whyUsCard3 = $pages[2];
        $servicePage = $pages[3];
        $numbersPage = $pages[4];
        $doctorPage = $pages[5];
        $newsPage = $pages[6];
        $aboutUsPage = $pages[7];
        $workingHoursPage = $pages[8];
        $insurancePartnerPage = $pages[9];
        $conferencePage = $pages[10];


        $servicePageTitle = explode(' ', $servicePage->title);
        $servicePageTitle2 = array_pop($servicePageTitle);
        $servicePageTitle1 = implode(' ', $servicePageTitle);

        $numberPageTitle = explode(' ', $numbersPage->title);
        $numberPageTitle2 = array_pop($numberPageTitle);
        $numberPageTitle1 = implode(' ', $numberPageTitle);

        $doctorPageTitle = explode(' ', $doctorPage->title);
        $doctorPageTitle2 = array_pop($doctorPageTitle);
        $doctorPageTitle1 = implode(' ', $doctorPageTitle);

        $newsPageTitle = explode(' ', $newsPage->title);
        $newsPageTitle2 = array_pop($newsPageTitle);
        $newsPageTitle1 = implode(' ', $newsPageTitle);

        $conferencePageTitle = explode(' ', $conferencePage->title);
        $conferencePageTitle2 = array_pop($conferencePageTitle);
        $conferencePageTitle1 = implode(' ', $conferencePageTitle);

        $contactFormTitle = explode(' ', __('visitorMessages.send_us_message'));
        $contactFormTitle2 = array_pop($contactFormTitle);
        $contactFormTitle1 = implode(' ', $contactFormTitle);

        $aboutUsPageTitle = explode(' ', $aboutUsPage->title);
        $aboutUsTitle2 = array_pop($aboutUsPageTitle);
        $aboutUsTitle1 = implode(' ', $aboutUsPageTitle);

        $insurancePartnerPageTitle = explode(' ', $insurancePartnerPage->title);
        $insurancePartnerTitle2 = array_pop($insurancePartnerPageTitle);
        $insurancePartnerTitle1 = implode(' ', $insurancePartnerPageTitle);

        $insurancePartners = Partner::withDescription('insurance');
        $doctors = Doctor::withDescription([], false, true);
        $workHours = WorkHour::get(['status', 'week_day', 'time_from', 'time_to'])->chunk(4)->toArray();

        $articles = Article::withDescription([], 6, null, true);
        $conferences = Conference::withDescription([], 3);


        return view($this->view.'home', get_defined_vars());
    }

    public function bookingAppointment()
    {
        $title = __('main.book_appointment');
        return view($this->view.'book_appointment', get_defined_vars());
    }

}
