<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePhotoDescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('photo_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('title',100)->nullable();

            $table->unsignedBigInteger('photo_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('photo_id')->references('id')->on('photos')->cascadeOnDelete();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('photo_descriptions');
    }
}
