<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePartnerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partners', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['partner', 'insurance'])->nullable();
            $table->string('image', 200)->nullable();
            $table->string('url', 300)->nullable();

            $table->softDeletes();
            $table->timestamps();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partners');
    }
}
