<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWorkHoursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('work_hours', function (Blueprint $table) {
            $table->id();
            $table->enum('status', ['open', 'closed']);
            $table->enum('week_day', ['sat', 'sun', 'mon', 'tue', 'wed', 'thu', 'fri'])->unique();
            $table->time('time_from')->nullable();
            $table->time('time_to')->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->engine = 'InnoDB';

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('work_hours');
    }
}
