<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateConferenceDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('conference_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('title', 100)->nullable();
            $table->longText('description')->nullable();

            $table->unsignedBigInteger('conference_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('conference_id')->references('id')->on('conferences')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('conference_descriptions');
    }
}
