<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBannerDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banner_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('title', 100);
            $table->text('description');

            $table->unsignedBigInteger('banner_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('banner_id')->references('id')->on('banners')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banner_descriptions');
    }
}
