<?php

use App\Article;
use App\ArticleDescription;
use Illuminate\Database\Seeder;

class ArticleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/news-4.jpg',
            'assets/web/images/news-2.jpg',
            'assets/web/images/news-1.jpg',
        ];

        foreach ($images as $image) {
            factory(Article::class)->create(['image' => $image]);
        }

        foreach (languages() as $language){
            foreach (Article::cursor() as $article) {
                factory(ArticleDescription::class)->create([
                    'article_id' => $article->id,
                    'language_id' => $language->id,
                ]);
            }

        }
    }
}
