<?php

use Illuminate\Database\Seeder;

class DirectorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/manager-1.png',
            'assets/web/images/manager-2.png',
            'assets/web/images/manager-3.png',
            'assets/web/images/manager-4.png',
            'assets/web/images/manager-5.png',
        ];

        foreach ($images as $image) {
            $directors = factory(\App\Director::class)->create(['image' => $image]);
        }

        foreach (\App\Director::cursor() as $director) {
            foreach (languages() as $language) {
                factory(\App\DirectorDescription::class)->create([
                    'director_id' => $director->id,
                    'language_id' => $language->id,
                ]);
            }

        }

    }
}
