<?php

use Illuminate\Database\Seeder;

class FlavorTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/avatar-1.png',
            'assets/web/images/avatar-2.png',
        ];

        foreach ($images as $image) {
            factory(\App\FlavorType::class)->create(['image' => $image]);
        }

        foreach (languages() as $language) {
            factory(\App\FlavorTypeDescription::class)->create([
                'name' => 'Dairy Free',
                'flavor_type_id' => 1,
                'language_id' => $language->id
            ]);

            factory(\App\FlavorTypeDescription::class)->create([
                'name' => 'Dairy Free',
                'flavor_type_id' => 2,
                'language_id' => $language->id
            ]);
        }



    }

}
