<?php

use App\Partner;
use App\PartnerDescription;
use Illuminate\Database\Seeder;

class PartnerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/partners-1.png',
            'assets/web/images/partners-2.png',
            'assets/web/images/partners-3.png',
            'assets/web/images/partners-4.png',
        ];

        foreach ($images as $image) {
            factory(Partner::class)->create(['image' => $image, 'type' => 'partner']);
            factory(Partner::class)->create(['image' => $image, 'type' => 'insurance']);
        }
        foreach (Partner::cursor() as $partner) {
            foreach (languages() as $language) {
                factory(PartnerDescription::class)->create([
                    'partner_id' => $partner->id,
                    'language_id' => $language->id,
                ]);
            }
        }
    }
}
