<?php

use Illuminate\Database\Seeder;

class WorkHourSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \Carbon\Carbon::setWeekStartsAt(\Carbon\Carbon::FRIDAY);
        $date = \Illuminate\Support\Carbon::now();
        $days = ['sat', 'sun', 'mon', 'tue', 'wed', 'thu', 'fri'];
        foreach ($days as $day) {
            factory(\App\WorkHour::class)->create([
                'status' => 'open',
                'week_day' => $day,
                'time_from' =>  $date->addHours(0)->format('H:i'),
                'time_to' => $date->addHours(12)->format('H:i'),
            ]);
        }
    }
}
