function sendAjax(buttonSelector = 'button', formSelector = 'form', route = null, methodType = null,  dataType = 'json', appendData = []){
    $(buttonSelector).click(async function (e) {
        e.preventDefault();

        $(this).prop('disabled', true);

        $('.my-editor').each(function () {
            $(this).html( tinymce.get($(this).attr('id')).getContent());
        });

        let form = $(formSelector),
            data = new FormData(form[0]),
            url = route ?? form.attr('action'),
            method = methodType ?? form.attr('method');

        if (appendData.length){
            appendData.forEach((value)=>{
                data.append(value[0], value[1]);
            })
        }

        const response=await ajax({
            url,
            data,
            dataType: dataType,
            method
        });

        if (response.url){
            window.location.href = response.url;
        }

        if (response.errors){
            $(this).prop('disabled', false);
            toasterError(response.errors);
        }

        if (response.message){
            $(this).prop('disabled', false);
            toasterSuccess(response.message);
        }

    });
}
