@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" >
        <div class="form-group col-lg-6">
            <label>{{ meta('name', $lang) ?? __('careerApplications.name') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->name }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('career_id', $lang) ?? __('careerApplications.career_id') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->careerName }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('submission_date', $lang) ?? __('careerApplications.submission_date') }}</label>
            <input readonly class="form-control bg-white" value='{{ date('Y-m-d', strtotime($application->created_at)) }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('phone', $lang) ?? __('careerApplications.phone') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->phone }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('birth_date', $lang) ?? __('careerApplications.birth_date') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->birth_date }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('country_id', $lang) ?? __('careerApplications.country_id') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->nationality }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('address', $lang) ?? __('careerApplications.address') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->address }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('education_id', $lang) ?? __('careerApplications.education_id') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->education }}'/>
        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('service_id', $lang) ?? __('careerApplications.service_id') }}</label>
            <input readonly class="form-control bg-white" value='{{ $application->specializationName }}'/>
        </div>

        <div class="col-md-12 mb-1">
            <div class="items">
                <div class="img">
                    @if(strpos($application->cv, '.pdf'))
                        <a href="{{ asset($application->cv)}}"><img style="object-fit: contain; padding: 50px;" src="{{asset(strpos($application->cv, '.pdf') ? 'assets/admin/images/file-icon.png' : $application->cv)}}" alt=""></a>
                    @else
                        <a href="{{ asset($application->cv)}}" data-fancybox><img src="{{ asset($application->cv)}}" alt=""></a>
                    @endif
                </div>
            </div>

        </div>
        <div class="col-md-12">
            <a class="btn btn-success" download href="{{asset($application->cv)}}"><i class="fa fa-download"></i> {{__('careerApplications.download_cv')}}</a>
        </div>

        <div class="text-center mt-5 col-12">
            <a href="{{route('careerApplications.index')}}" class="butn"><span>{{ __('careerApplications.head') }}</span></a>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <script>

    </script>

@endsection



