@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? '' }}</h3>
</div>

   @if (auth()->user()->role == 'super_admin')
       <ul class="nav nav-tabs" id="myTab" role="tablist">
           <li class="nav-item">
               <a class="nav-link active" id="site-settings-tab" data-toggle="tab" href="#site-settings" role="tab" aria-controls="site-settings" aria-selected="true">
                   <b>{{__('settings.site_settings')}}</b>
               </a>
           </li>
           <li class="nav-item">
               <a class="nav-link" id="modules-settings-tab" data-toggle="tab" href="#modules-settings" role="tab" aria-controls="modules-settings" aria-selected="false">
                   <b>{{__('settings.module_settings')}}</b>
               </a>
           </li>
       </ul>
       <div class="tab-content" id="myTabContent">
           <div class="tab-pane fade show active" id="site-settings" role="tabpanel" aria-labelledby="site-settings-tab">
               @include('admin.settings.site_settings')
           </div>
           <div class="tab-pane fade show" id="modules-settings" role="tabpanel" aria-labelledby="modules-settings-tab">
               @include('admin.settings.module_settings')
           </div>
       </div>
       @else
       @include('admin.settings.site_settings')
   @endif



@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/settings.js') }}"></script>

    <script>
        sendAjax('.site_settings_button', '.site_settings_form');
        sendAjax('.module_settings_button', '.module_settings_form');
    </script>
@endsection
