@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($videoCategory ?? ''  && $videoCategory->id)
            @method('PUT')
        @endif
        @CSRF

        @foreach($languages as $language)
        <div class="form-group col-lg-6">
            <label>{{ meta('name', $language->local) ?? __('videoCategories.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('videoCategories.name') }}" value='{{ old("name_{$language->local}", $videoCategory[$language->local]->name ?? "") }}'/>
        </div>

        <div class="form-group col-lg-6">
            <label>{{ meta('slug', $language->local) ?? __('videoCategories.slug') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('slug_'.$language->local) ? 'is-invalid' : '' }}" name="slug_{{ $language->local }}" placeholder="{{ meta('slug', $language->local) ?? __('videoCategories.slug') }}" value='{{ old("slug_{$language->local}", $videoCategory[$language->local]->slug ?? "") }}'/>
        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('keywords', $language->local) ?? __('videoCategories.keywords') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('keywords_'.$language->local) ? 'is-invalid' : '' }}" name="keywords_{{ $language->local }}" placeholder="{{ meta('keywords', $language->local) ?? __('videoCategories.keywords') }}" value='{{ old("keywords_{$language->local}", $videoCategory[$language->local]->keywords ?? "") }}'/>

        </div>

        <div class="form-group col-lg-12">
            <label>{{ meta('meta_description', $language->local) ?? __('videoCategories.meta_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('meta_description_'.$language->local) ? 'is-invalid' : '' }}" name="meta_description_{{ $language->local }}" placeholder="{{meta('meta_description', $language->local) ??  __('videoCategories.meta_description') }}" value='{{ old("meta_description_{$language->local}", $videoCategory[$language->local]->meta_description ?? "") }}'/>
        </div>
        @endforeach

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection
