<?php

//use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

//Route::get('language/{id}/{slug?}', 'LanguageController@details');
/**
 * Localization Group
 */

Route::group(['prefix' => LaravelLocalization::setLocale()], function(){

    Route::get('/', function () {

//        \Carbon\Carbon::setWeekStartsAt(\Carbon\Carbon::FRIDAY);
//        $date = \Illuminate\Support\Carbon::now();
//
//        $weekDates = [];
//        $startOfWeek = $date->startOfWeek();
//
//        for ($i = 1; $i <= 7; $i++){
//            $x = $startOfWeek->addDay();
//            $key = strtolower($x->shortEnglishDayOfWeek);
//            $day = $x->getTranslatedDayName();
//            $weekDates[$key] = $day;
//        }
//        return redirect('/admin/login');
    });

    Route::group(['namespace' => 'Web','middleware' => [ 'checkWebSiteEnabled', 'WebsiteVisitorCount'] ], function () {

        Route::get('/', 'HomeController@index')->name('home');
        Route::get('/partners', 'PartnerController@index')->name('partner.index');
        Route::get('pages/{id?}/{type}', 'PageController@show')->name('page.show');

        Route::get('/booking-appointment', 'HomeController@bookingAppointment')->name('bookingAppointment');

        Route::group(['prefix' => 'service'], function (){
            Route::get('/', 'ServiceController@index')->name('service.index');
            Route::get('/{service}', 'ServiceController@show')->name('service.show');
        });

        Route::group(['prefix' => 'careers'], function (){
            Route::get('/', 'CareerController@index')->name('jobs.index');
            Route::get('careers/apply/{career}', 'CareerController@careerApplyFrom')->name('career.applyFrom');
            Route::post('careers/apply/{career}', 'CareerController@careerApply')->name('career.apply');
        });

        Route::group(['prefix' => 'medical-topics'], function (){
            Route::get('/', 'NewsController@index')->name('news.index');
            Route::get('/{new}', 'NewsController@show')->name('news.show');
            Route::get('news/see/more', 'NewsController@seeMore')->name('news.seeMore');
        });

        Route::group(['prefix' => 'latest-news'], function (){
            Route::get('/', 'ConferenceController@index')->name('conference.index');
            Route::get('/{conference}', 'ConferenceController@show')->name('conference.show');
            Route::get('/see/more', 'ConferenceController@seeMore')->name('conference.seeMore');
        });



        Route::get('doctors', 'DoctorController@index')->name('doctor.index');
        Route::get('galleries', 'GalleryController@index')->name('gallery.index');
        Route::get('offers', 'BannerController@index')->name('banner.index');
        Route::get('/contact-us', 'VisitorMessageController@index')->name('contact.index');
        Route::post('/contact-us', 'VisitorMessageController@store')->name('contact.store');


    });


    /**
     * this route for the central admin and central super admin to enable them to use this website
     */
    Route::get('/login/{admin_token}', 'Auth\LoginController@superAdminLogin')->name('superAdminLogin');

    /**
     * Authentication routes , and Authentication user routs
     */
//	Auth::routes();

    /**
     * Admin Routes
     */
    Route::group([ 'prefix'=> 'admin', 'namespace' => 'Admin'], function () {

        Route::get('/login', 'LoginController@index');
        Route::post('/login', 'LoginController@authenticate')->name('admin_login');

        Route::group([ 'middleware' => ['admin_auth']], function () {
            Route::get('/', 'DashboardController@index')->name('dashboard');

            Route::post('/logout', 'LoginController@logout')->name('admin_logout');

            Route::group([ 'middleware' => ['checkRole']], function () {


                Route::put('/countries/restore/{id}', 'CountryController@restore')->name('countries.restore');
                Route::put('/countries/restore', 'CountryController@restoreAll')->name('countries.restoreAll');
                Route::delete('/countries', 'CountryController@destroyAll')->name('countries.destroyAll');
                Route::get('/countries/grid', 'CountryController@grid')->name('countries.grid');
                Route::resource('/countries', 'CountryController');

                Route::put('/educations/restore/{id}', 'EducationController@restore')->name('educations.restore');
                Route::put('/educations/restore', 'EducationController@restoreAll')->name('educations.restoreAll');
                Route::delete('/educations', 'EducationController@destroyAll')->name('educations.destroyAll');
                Route::get('/educations/grid', 'EducationController@grid')->name('educations.grid');
                Route::resource('/educations', 'EducationController');

                Route::put('/directors/restore/{id}', 'DirectorController@restore')->name('directors.restore');
                Route::put('/directors/restore', 'DirectorController@restoreAll')->name('directors.restoreAll');
                Route::delete('/directors', 'DirectorController@destroyAll')->name('directors.destroyAll');
                Route::get('/directors/grid', 'DirectorController@grid')->name('directors.grid');
                Route::resource('/directors', 'DirectorController');

                Route::put('/doctors/restore/{id}', 'DoctorController@restore')->name('doctors.restore');
                Route::put('/doctors/restore', 'DoctorController@restoreAll')->name('doctors.restoreAll');
                Route::delete('/doctors', 'DoctorController@destroyAll')->name('doctors.destroyAll');
                Route::get('/doctors/grid', 'DoctorController@grid')->name('doctors.grid');
                Route::resource('/doctors', 'DoctorController');

                Route::put('/services/restore/{id}', 'ServiceController@restore')->name('services.restore');
                Route::put('/services/restore', 'ServiceController@restoreAll')->name('services.restoreAll');
                Route::delete('/services', 'ServiceController@destroyAll')->name('services.destroyAll');
                Route::get('/services/grid', 'ServiceController@grid')->name('services.grid');
                Route::resource('/services', 'ServiceController');

                Route::put('/conferences/restore/{id}', 'ConferenceController@restore')->name('conferences.restore');
                Route::put('/conferences/restore', 'ConferenceController@restoreAll')->name('conferences.restoreAll');
                Route::delete('/conferences', 'ConferenceController@destroyAll')->name('conferences.destroyAll');
                Route::get('/conferences/grid', 'ConferenceController@grid')->name('conferences.grid');
                Route::resource('/conferences', 'ConferenceController');

                Route::put('/careers/restore/{id}', 'CareerController@restore')->name('careers.restore');
                Route::put('/careers/restore', 'CareerController@restoreAll')->name('careers.restoreAll');
                Route::delete('/careers', 'CareerController@destroyAll')->name('careers.destroyAll');
                Route::get('/careers/grid', 'CareerController@grid')->name('careers.grid');
                Route::resource('/careers', 'CareerController');

                Route::put('/careerApplications/restore/{id}', 'CareerApplicationController@restore')->name('careerApplications.restore');
                Route::put('/careerApplications/restore', 'CareerApplicationController@restoreAll')->name('careerApplications.restoreAll');
                Route::delete('/careerApplications', 'CareerApplicationController@destroyAll')->name('careerApplications.destroyAll');
                Route::get('/careerApplications/grid', 'CareerApplicationController@grid')->name('careerApplications.grid');
                Route::resource('/careerApplications', 'CareerApplicationController')->only(['index', 'edit', 'destroy']);

                Route::get('/workHours/grid', 'WorkHourController@grid')->name('workHours.grid');
                Route::resource('/workHours', 'WorkHourController')->only(['index', 'edit', 'update']);

                Route::put('/sliders/restore/{id}', 'SliderController@restore')->name('sliders.restore');
                Route::put('/sliders/restore', 'SliderController@restoreAll')->name('sliders.restoreAll');
                Route::delete('/sliders', 'SliderController@destroyAll')->name('sliders.destroyAll');
                Route::get('/sliders/grid', 'SliderController@grid')->name('sliders.grid');
                Route::resource('/sliders', 'SliderController');

                Route::put('/galleries/restore/{id}', 'GalleryController@restore')->name('galleries.restore');
                Route::put('/galleries/restore', 'GalleryController@restoreAll')->name('galleries.restoreAll');
                Route::delete('/galleries', 'GalleryController@destroyAll')->name('galleries.destroyAll');
                Route::get('/galleries/grid', 'GalleryController@grid')->name('galleries.grid');
                Route::resource('/galleries', 'GalleryController');

                Route::put('/banners/restore/{id}', 'BannerController@restore')->name('banners.restore');
                Route::put('/banners/restore', 'BannerController@restoreAll')->name('banners.restoreAll');
                Route::delete('/banners', 'BannerController@destroyAll')->name('banners.destroyAll');
                Route::get('/banners/grid', 'BannerController@grid')->name('banners.grid');
                Route::resource('/banners', 'BannerController')->except(['create', 'store', 'destroy']);

                Route::get('/pages/grid', 'PageController@grid')->name('pages.grid');
                Route::resource('/pages', 'PageController')->only(['index', 'edit', 'update']);

                Route::put('/reviews/restore/{id}', 'ReviewController@restore')->name('reviews.restore');
                Route::put('/reviews/restore', 'ReviewController@restoreAll')->name('reviews.restoreAll');
                Route::delete('/reviews', 'ReviewController@destroyAll')->name('reviews.destroyAll');
                Route::get('/reviews/grid', 'ReviewController@grid')->name('reviews.grid');
                Route::resource('/reviews', 'ReviewController');

                Route::put('/articles/restore/{id}', 'ArticleController@restore')->name('articles.restore');
                Route::put('/articles/restore', 'ArticleController@restoreAll')->name('articles.restoreAll');
                Route::delete('/articles', 'ArticleController@destroyAll')->name('articles.destroyAll');
                Route::get('/articles/grid', 'ArticleController@grid')->name('articles.grid');
                Route::resource('/articles', 'ArticleController');

                Route::put('/partners/restore/{id}', 'PartnerController@restore')->name('partners.restore');
                Route::put('/partners/restore', 'PartnerController@restoreAll')->name('partners.restoreAll');
                Route::delete('/partners', 'PartnerController@destroyAll')->name('partners.destroyAll');
                Route::get('/partners/grid', 'PartnerController@grid')->name('partners.grid');
                Route::resource('/partners', 'PartnerController');


                // VISITOR MESSAGE ROUTES
                Route::put('/visitorMessages/restore/{id}', 'VisitorMessageController@restore')->name('visitorMessages.restore');
                Route::put('/visitorMessages/restore', 'VisitorMessageController@restoreAll')->name('visitorMessages.restoreAll');
                Route::delete('/visitorMessages', 'VisitorMessageController@destroyAll')->name('visitorMessages.destroyAll');
                Route::get('/visitorMessages/grid', 'VisitorMessageController@grid')->name('visitorMessages.grid');
                Route::resource('/visitorMessages', 'VisitorMessageController');

                // USER ROUTES
                Route::put('/users/restore/{id}', 'UserController@restore')->name('users.restore');
                Route::put('/users/restore', 'UserController@restoreAll')->name('users.restoreAll');
                Route::delete('/users', 'UserController@destroyAll')->name('users.destroyAll');
                Route::get('/users/grid', 'UserController@grid')->name('users.grid');
                Route::resource('/users', 'UserController');

                // SETTING ROUTES
                Route::get('/settings', 'SettingController@index')->name('settings.index');
                Route::post('/settings', 'SettingController@store')->name('settings.store');
                Route::post('/modules-settings', 'SettingController@modules')->name('settings.modules');


            });  // End Role Routes


            Route::resource('/languages', 'LanguageController');
            // Route::post('/languages/{id}', 'LanguageController@update')->name('languages');

        }); // End Authenticated Admin routes
    }); // End Admin Routes

});
