<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="<?php echo e($settings['meta_description_'.$lang]); ?> - <?php echo e($meta_description ?? ($title ?? '')); ?>" />
    <meta name="keywords" content="<?php echo e($settings['keywords_'.$lang]); ?> , <?php echo e($keywords ??  ($title ?? '')); ?>" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e($settings['website_name_'.$lang]); ?> - <?php echo e(($title ?? '')); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset($logo ?? 'assets/web/images/logo.svg')); ?>" type="image/x-icon" />





       <?php if(app()->getLocale() == 'en'): ?>
           <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/bootstrap.min.css')); ?>" />
       <?php endif; ?>

        <?php if(app()->getLocale() == 'ar'): ?>
       <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/bootstrap.rtl.css')); ?>" />
      <?php endif; ?>


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />    <!--Css Files & Libraries-->
    <link href="https://fonts.googleapis.com/css2?family=Almarai:wght@300;400;700;800&display=swap" rel="stylesheet">
    
    <!--en font --------->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;500;700;900&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/jquery.fancybox.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/lib/toastr.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/media.css')); ?>" />

        <?php if(app()->getLocale() == 'ar'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/web/css/style-ar.css')); ?>" />
        <?php endif; ?>


    <?php echo $__env->yieldContent('css'); ?>

</head>

<body>

<div id="preloader">
    <div id="loading-wrapper" class="show">
        <div id="loading-text"> <img src="<?php echo e(asset('assets/web/images/shape-1.png')); ?>" alt=""> </div>
        <div id="loading-content"></div>
    </div>
</div>

<?php echo $__env->yieldContent('container_content'); ?>

<script src="<?php echo e(asset('assets/web/js/lib/jquery4.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/popper.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/bootstrap.bundle.min.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/jquery.fancybox.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/swiper.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/wow.min.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/jquery.counterup.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/jquery.waypoints.min.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/back-to-top.js')); ?> "></script>
<script src="<?php echo e(asset('assets/web/js/lib/toastr.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/web/js/lib/axios.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/web/js/main.js')); ?> "></script>

    <script>
        var swiper = new Swiper('.mainhead-slider .swiper-container', {
            slidesPerView: 1,
            spaceBetween: 30,
            centeredSlides: true,
            speed: 1000,
            pagination: {
                el: ".mainhead-slider .swiper-pagination",
                clickable: true,
            },
            navigation: false,
            mousewheel: false,
            keyboard: true,
            autoplay: {
                delay: 5000,
            },
            loop: true,
        });
    </script>


<?php echo $__env->yieldContent('container_js'); ?>
</body>

</html>
<?php /**PATH /home/balyomhost/public_html/procare/resources/views/web/layouts/layout.blade.php ENDPATH**/ ?>