<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'CMS') .' - '. ($title ?? '')); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset($logo ?? 'assets/admin/images/logo.svg')); ?>" title="Favicon" sizes="16x16" />

    <?php if(app()->getLocale() == 'ar'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/bootstrap-rtl.min.css')); ?>" />
    <?php endif; ?>

    <?php if(app()->getLocale() == 'en'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/bootstrap-ltr.min.css')); ?>" />
    <?php endif; ?>
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,400i,500,500i,700,900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Rubik:400,500,700,900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/jquery-ui.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/jquery-ui.theme.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/jquery.fancybox.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/lib/toastr.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/styles.css')); ?>" />


    <?php if(app()->getLocale() == 'ar'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/style_ar.css')); ?>" />
    <?php endif; ?>

    <!----------- new style links ----------->

    <!-- ------- data table style -------------- -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.23/css/dataTables.bootstrap4.min.css">
    <!-- ------- datepicker style -------------- -->
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <!----------- end new style links ----------->

</head>

<body>

<?php echo $__env->yieldContent('container_content'); ?>
<script src="<?php echo e(asset('assets/admin/js/lib/jquery-3.0.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/lib/jquery-migrate-3.0.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/lib/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/lib/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/lib/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/lib/jquery-ui.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/lib/jquery.fancybox.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/lib/toastr.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/main.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/ajax_functions.js')); ?>"></script>
<?php echo $__env->yieldContent('container_js'); ?>
</body>

</html>
<?php /**PATH /home/balyomhost/public_html/procare/resources/views/admin/layouts/layout.blade.php ENDPATH**/ ?>