<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_doctor_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($doctor ?? ''  && $doctor->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

            <div class="col-md-4">
                <label><?php echo e(meta('show_in_chairman', $lang) ?? __('doctors.show_in_chairman')); ?> </label>
                <select name="show_in_chairman" class="form-control">
                    <option <?php echo e(($doctor->show_in_chairman ?? null) == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('doctors.yes')); ?></option>
                    <option <?php echo e(($doctor->show_in_chairman ?? null) == '0' ? 'selected' : ''); ?> value="0"><?php echo e(__('doctors.no')); ?></option>
                </select>
            </div>
            <div class="col-md-4">
                <label><?php echo e(meta('show_in_home', $lang) ?? __('doctors.show_in_home')); ?> </label>
                <select name="show_in_home" class="form-control">
                    <option <?php echo e(($doctor->show_in_home ?? null) == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('doctors.yes')); ?></option>
                    <option <?php echo e(($doctor->show_in_home ?? null) == '0' ? 'selected' : ''); ?> value="0"><?php echo e(__('doctors.no')); ?></option>
                </select>
            </div>
            <div class="col-md-4">
                <label><?php echo e(meta('show_in_offers', $lang) ?? __('doctors.show_in_offers')); ?> </label>
                <select name="show_in_offers" class="form-control">
                    <option <?php echo e(($doctor->show_in_offers ?? null) == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('doctors.yes')); ?></option>
                    <option <?php echo e(($doctor->show_in_offers ?? null) == '0' ? 'selected' : ''); ?> value="0"><?php echo e(__('doctors.no')); ?></option>
                </select>
            </div>
            <div class="form-group col-lg-6 <?php echo e(($doctor->discount_percentage ?? null) ? '' : 'd-none'); ?> category_container">
                <label><?php echo e(meta('category_id', $lang) ?? __('doctors.category_id')); ?> </label>
                <select name="category_id" class="form-control">
                    <option value=""><?php echo e(meta('category_id', $lang) ?? __('doctors.category_id')); ?></option>
                    <option <?php echo e(($doctor->category_id ?? null) == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('doctors.category_1')); ?></option>
                    <option <?php echo e(($doctor->category_id ?? null) == 2 ? 'selected' : ''); ?> value="2"><?php echo e(__('doctors.category_2')); ?></option>
                    <option <?php echo e(($doctor->category_id ?? null) == 3 ? 'selected' : ''); ?> value="3"><?php echo e(__('doctors.category_3')); ?></option>
                </select>
            </div>
            <div class="form-group col-lg-6 <?php echo e(($doctor->discount_percentage ?? null) ? '' : 'd-none'); ?> discount_percentage_container">
                <label><?php echo e(meta('discount_percentage', $lang) ?? __('doctors.discount_percentage')); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('discount_percentage') ? 'is-invalid' : ''); ?>" name="discount_percentage" placeholder="<?php echo e(meta('discount_percentage', $lang) ?? __('doctors.discount_percentage')); ?>" value='<?php echo e(old("discount_percentage", $doctor->discount_percentage ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('facebook', $lang) ?? __('doctors.facebook')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('facebook') ? 'is-invalid' : ''); ?>" name="facebook" placeholder="<?php echo e(meta('facebook', $lang) ?? __('doctors.facebook')); ?>" value='<?php echo e(old("facebook", $doctor->facebook ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('twitter', $lang) ?? __('doctors.twitter')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('twitter') ? 'is-invalid' : ''); ?>" name="twitter" placeholder="<?php echo e(meta('twitter', $lang) ?? __('doctors.twitter')); ?>" value='<?php echo e(old("twitter", $doctor->twitter ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('instagram', $lang) ?? __('doctors.instagram')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('instagram') ? 'is-invalid' : ''); ?>" name="instagram" placeholder="<?php echo e(meta('instagram', $lang) ?? __('doctors.instagram')); ?>" value='<?php echo e(old("instagram", $doctor->instagram ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('linkedin', $lang) ?? __('doctors.linkedin')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('linkedin') ? 'is-invalid' : ''); ?>" name="linkedin" placeholder="<?php echo e(meta('linkedin', $lang) ?? __('doctors.linkedin')); ?>" value='<?php echo e(old("linkedin", $doctor->linkedin ?? "")); ?>'/>
            </div>
            <div class="form-group col-lg-12">
                <label><?php echo e(meta('okadoc_url', $lang) ?? __('doctors.okadoc_url')); ?> </label>
                <input type="url" class="form-control <?php echo e($errors->has('okadoc_url') ? 'is-invalid' : ''); ?>" name="okadoc_url" placeholder="<?php echo e(meta('okadoc_url', $lang) ?? __('doctors.okadoc_url')); ?>" value='<?php echo e(old("okadoc_url", $doctor->okadoc_url ?? "")); ?>'/>
            </div>


            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('name', $language->local) ?? __('doctors.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('doctors.name')); ?>" value='<?php echo e(old("name_{$language->local}", $doctor[$language->local]->name ?? "")); ?>'/>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('specialist', $language->local) ?? __('doctors.specialist')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="specialist_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('specialist_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('specialist', $language->local) ?? __('doctors.specialist')); ?>"><?php echo e(old("specialist_{$language->local}", $doctor[$language->local]->specialist ?? "")); ?></textarea>
                </div>




















                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('details', $language->local) ?? __('doctors.details')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" id="details_<?php echo e($language->local); ?>" name="details_<?php echo e($language->local); ?>" class="form-control my-editor <?php echo e($errors->has('details_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('details', $language->local) ?? __('doctors.details')); ?>"><?php echo e(old("details_{$language->local}", $doctor[$language->local]->details ?? "")); ?></textarea>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <div class="form-group col-lg-12 image_container">
                <label><?php echo e(meta('image', $lang) ?? __('doctors.image')); ?> </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $doctor->image ?? "")); ?>"/>

                <div class="photos main_photo <?php echo e(old('image', $doctor->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', $doctor->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button <?php echo e(old('image', $doctor->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
            </div>
            


        <div class="text-center mt-5 col-12">
            <button class="butn add_doctor_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_doctor_button', '.add_doctor_form');

        let selectedOption = $('select[name="show_in_offers"] option:selected').val();

        if(selectedOption === '1'){
            $('.category_container, .discount_percentage_container').removeClass('d-none');
        }
        if(selectedOption === '0'){
            $('.category_container, .discount_percentage_container').addClass('d-none');
            $('input[name="category_id"], input[name="discount_percentage"]').val(null);
        }


        $('select[name="show_in_offers"]').change(function () {
            let thisVal = $(this).val();
            if(thisVal === '1'){
                $('.category_container, .discount_percentage_container').removeClass('d-none');
            }

            if(thisVal === '0'){
                $('.category_container, .discount_percentage_container').addClass('d-none');
                $('select[name="category_id"], input[name="discount_percentage"]').val(null);
            }
        })
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/balyomhost/public_html/procare/resources/views/admin/doctors/form.blade.php ENDPATH**/ ?>