@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($director ?? ''  && $director->id)
            @method('PUT')
        @endif
        @csrf

        @foreach(languages() as $language)
            <div class="form-group col-lg-12">
                <label>{{ meta('name', $language->local) ?? __('directors.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('directors.name') }}" value='{{ old("name_{$language->local}", $director[$language->local]->name ?? "") }}'/>
            </div>
            <div class="form-group col-lg-12">
                <label>{{ meta('specialist', $language->local) ?? __('directors.specialist') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('specialist_'.$language->local) ? 'is-invalid' : '' }}" name="specialist_{{ $language->local }}" placeholder="{{ meta('specialist', $language->local) ?? __('directors.specialist') }}" value='{{ old("specialist_{$language->local}", $director[$language->local]->specialist ?? "") }}'/>
            </div>
            <div class="form-group col-lg-12">
                <label>{{ meta('description', $language->local) ?? __('directors.description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <textarea rows="5" name="description_{{ $language->local }}" class="form-control {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('directors.description')}}">{{ old("description_{$language->local}", $director[$language->local]->description ?? "") }}</textarea>
            </div>
        @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12 image_container">
                <label>{{ meta('image', $lang) ?? __('directors.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $director->image ?? "")}}"/>

                <div class="photos main_photo {{ old('image', $director->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $director->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $director->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
            </div>
            {{--End image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

@endsection



