<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Doctor
 * @package App
 * @mixin Builder
 */
class Doctor extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'image',
        'facebook',
        'twitter',
        'instagram',
        'linkedin',
    ];

    public static function withDescription($ids = [])
    {
        $query = self::join('doctor_descriptions as doctorDesc', 'doctorDesc.doctor_id', 'doctors.id')
            ->where('doctorDesc.language_id', currentLanguage()->id);
        if (count($ids)){
            $query->whereIn('doctors.id', $ids);
        }
        $query->select(['doctorDesc.*', 'doctors.*']);

        return $query->get();
    }

}
