<?php

namespace App\Http\Controllers\Web;

use App\Conference;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;


class ConferenceController extends Controller
{
    private $view = 'web.conferences.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $conferences = Conference::withDescription([], 3);
        $title = __('conferences.head');
        $firstEvent = $conferences->first();
       return view($this->view.'index', get_defined_vars());
    }

    public function show(Conference $conference)
    {
        $conference = $conference->with('currentDescription')->first();
        $title = __('conferences.conference_details');
        return view($this->view.'show', get_defined_vars());

    }


    public function seeMore(Request $request)
    {
        if ($request->ajax()){
            $conferences = Conference::withDescription([], 3, $request->skip);
            return view($this->view.'see_more', get_defined_vars());
        }
    }
}
