<?php

namespace App\Http\Controllers\Web;

use App\Doctor;
use App\Http\Controllers\Controller;
use App\Page;
use App\Service;
use Illuminate\View\View;


class ServiceController extends Controller
{
    private $view = 'web.services.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
       $services = Service::withDescription();
       $page = Page::withDescription([16]);
       $title = __('services.head');
       $pageTitle = explode(' ', $page->title);
       $pageTitle2 = array_pop($pageTitle);
       $pageTitle1 = implode(' ', $pageTitle);

       return view($this->view.'index', get_defined_vars());
    }

    public function show(Service $service)
    {
        $service = Service::withDescription($service->id);
        $title = $service->name;
        $doctors = Doctor::withDescription($service->doctor_ids ?? []);
        return view($this->view.'show', get_defined_vars());

    }

}
