<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Http\Requests\Web\VisitorMessageRequest;
use App\Page;
use App\VisitorMessage;
use App\WorkHour;
use Illuminate\Http\JsonResponse;

class VisitorMessageController extends Controller
{

    private $view = 'web.contacts.';


    public function index()
    {
        $pages = Page::withDescription([20,23]);
        $aboutUsPage = $pages[0];
        $contactUsPage = $pages[1];

        $title = $contactUsPage->page_title;

        $contactUsPageTitles = explode(' ', $contactUsPage->title);
        $contactUsTitle2 = array_pop($contactUsPageTitles);
        $contactUsTitle1 = implode(' ', $contactUsPageTitles);

        $aboutUsPageTitle = explode(' ', $aboutUsPage->title);
        $aboutUsTitle2 = array_pop($aboutUsPageTitle);
        $aboutUsTitle1 = implode(' ', $aboutUsPageTitle);

        $contactFormTitle = explode(' ', __('visitorMessages.send_us_message'));
        $contactFormTitle2 = array_pop($contactFormTitle);
        $contactFormTitle1 = implode(' ', $contactFormTitle);


        $workHours = WorkHour::get(['status', 'week_day', 'time_from', 'time_to'])->toArray();

        return view( $this->view.'index', get_defined_vars());
    }

    public function store(VisitorMessageRequest $request) :JsonResponse
    {
        VisitorMessage::create($request->all());
        return response()->json(['message' => __('visitorMessages.message_success')]);
    }
}
