<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

/**
 * @property mixed symbol
 */
class PageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (! Auth::check()) {
            return false;
        }
        if(Auth::user()->role == 'admin' )
        {
            return true;
        }

        if(Auth::user()->hasModule( 'pages' ) )
        {
            return true;
        }
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];
        foreach (languages() as $lang) {
            $lang_rules=[
                'page_title_'.$lang->local=> 'required|min:3|max:50',
            ];

            if (in_array($this->page->id, [1,2,3,4,5,6,7,8,9,10,11,12,13,15,16,17,18,19,20,22,23,24,25,26])){
                $lang_rules['title_'.$lang->local] = 'required|min:3|max:100';
            }
            if (in_array($this->page->id, [8, 13])){
                $lang_rules['title_2_'.$lang->local] = 'required|min:3|max:100';
            }

            if (in_array($this->page->id, [1,2,3,4,5,6,7,8,9,10,12,13,14,15,16,17,18,19,20,21,22,23,25,26])){
                $lang_rules['description_'.$lang->local] = 'required|min:3';
            }


            if (in_array($this->page->id, [8,7,13])){
                $lang_rules['description_2_'.$lang->local] = 'required|min:3';
            }

            $rules= array_merge($rules, $lang_rules);

//            if (in_array($this->page->id, [2,4])){
//                $rules["properties_$lang->local"] = 'required|array';
//                if (count(request('properties_'.$lang->local) ?? [])){
//                    foreach (request('properties_'.$lang->local) as $propName) {
//                        if (!$propName){
//                            $rules['all_properties_'.$lang->local] = 'required';
//                        }
//                    }
//                }
//            }

        }

        if (in_array($this->page->id, [8,13])){
            $rules['images'] = 'required|array|min:2|max:2';
        }


            if (in_array($this->page->id, [4,5,6,7,9,10,11,12,14,22])){
            $rules['image'] = 'required';
        }

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $field = metaFields('pages');
        $local = getCurrentLocale();
        $attributes=[
            'image' => $field[$local]['image'] ?? __('pages.image'),
            'images' => $field[$local]['images'] ?? __('pages.images'),

        ];
        foreach (languages() as $lang) {
            $local = $lang->local == 'ar' ? ' (عربي) ' : ' (English) ';
            $lang_attributes=[
                'page_title_'.$lang->local => ($field[$lang->local]['page_title'] ?? __('pages.page_title')) . $local,
                'title_'.$lang->local => ($field[$lang->local]['title'] ?? __('pages.title')) . $local,
                'title_2_'.$lang->local => ($field[$lang->local]['title_2'] ?? __('pages.title_2')) . $local,
                'description_'.$lang->local=> ($field[$lang->local]['description'] ?? __('pages.description')).$local,
                'description_2_'.$lang->local=> ($field[$lang->local]['description_2'] ?? __('pages.description_2')).$local,
                'all_properties_'.$lang->local => __('pages.properties') . $local,
                'property_description_'.$lang->local=> __('pages.property_description') . $local,
                'properties_'.$lang->local=> __('pages.property_title') . $local,

            ];
            $attributes= array_merge($attributes, $lang_attributes);
        }
        return $attributes;
    }
    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests

        if(Request::ajax()){
            $errors = $validator->errors()->first();
            throw new HttpResponseException(response()->json(['errors' => $errors]));
        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
