<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Partner extends Model
{
    // Fields that mass assignment
    protected $fillable = ['image', 'url', 'type'];

    // Use soft delete
    use SoftDeletes;

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(PartnerDescription::class);
    }

    public static function withDescription($type = null)
    {
        $query = self::join('partner_descriptions as pd', 'pd.partner_id', 'partners.id')
            ->where('pd.language_id', currentLanguage()->id);
        if ($type){
            $query->where('partners.type', $type);
        }

        return $query->select(['pd.name', 'partners.*'])->cursor() ?? [];
    }
}
