<?php

namespace App\Providers;

use App\Module;
use App\Setting;
use App\Language;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class AppServiceProvider extends ServiceProvider
{
    protected static $meta = null;

    /**
     * Register any application services.
     *
     * @return void
     */

    /**
     * @return null
     */
    public static function getMeta()
    {
        return self::$meta;
    }

    public function register()
    {

    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        date_default_timezone_set('Asia/Riyadh');

        // Fix migrate issue associated with index key length
        Schema::defaultStringLength(191);

        // CMS Supported Languages
        $languages= Language::where('status', 1)->cursor();
        View::share('languages', $languages);

        View::composer('*', function($view) {
            // Current Lang
            $view->with('lang', LaravelLocalization::getCurrentLocale());

            $isNotAdminRoute= request()->route() ? (strpos(request()->route()->getPrefix(), 'admin') === false) : true;
            $routePath= $this->app->request->getRequestUri();
            $routePath= explode('/', trim($routePath, '/'));
            // dd($isNotAdminRoute, count($routePath), request()->path());

            $activeMenu= [];
            if (!$isNotAdminRoute) {
                if ('admin' == $routePath[0] ) {
                    $activeMenu[$routePath[1] ?? ""]= 'active';
                    $view->with('activeMenu', $activeMenu);
                }
                if(($routePath[1] ?? null) && $routePath[1] == 'admin') {
                    $activeMenu[$routePath[2] ?? ""]= 'active';
                    $view->with('activeMenu', $activeMenu);
                }
                if(!count($activeMenu)) {
                    $activeMenu[$routePath[3] ?? ""]= 'active';
                    $view->with('activeMenu', $activeMenu);
                }
            } else {
                // Web

                // Main Info
                $settings = settings([
                    'website_logo',
                    'website_name_ar',
                    'website_name_en',
                    'keywords_ar',
                    'keywords_en',
                    'meta_description_ar',
                    'meta_description_en',
                    'site_address_ar',
                    'site_address_en',
                    'site_email',
                    'special_num_1_value',
                    'special_num_2_value',
                    'special_num_1_title_ar',
                    'special_num_1_title_en',
                    'special_num_2_title_ar',
                    'special_num_2_title_en',
                    'work_our_hint_ar',
                    'work_our_hint_en',
                    'site_phone',
                    'site_tel',
                    'facebook',
                    'twitter',
                    'instagram',
                    'tiktok',
                    'snapchat',
                    'linkedin',
                    'work_our_hint',
                    'career_link',
                    'site_map',
                    'show_start_pop_up',
                    'booking_appointment_url',
                ]);
                $view->with('settings', $settings);

                // Navigation Data

                // About Us Page Route
//                $aboutUs= Page::where('id', 1)->first();
//                $view->with('aboutUs', $aboutUs);

                // Portfolio Route
//                $portfolio= WebsiteCategory::where('id', 2)->first();
//                $view->with('portfolio', $portfolio ?? null);

                // Latest News Route
//                $latestNews= Category::where('id', 1)->first();
//                $view->with('latestNews', $latestNews ?? null);

                // Gallery Route
//                $gallery= PhotoCategory::where('id', 1)->first();
//                $view->with('gallery', $gallery ?? null);

                // Gallery Route
//                $videoGallery= VideoCategory::where('id', 1)->first();
//                $view->with('videoGallery', $videoGallery ?? null);
            }

            // Current User Info
            $userInfo= (object) ['photo'=> 'uploads/avatar.png'];
            if(Auth::check() && Auth::user()->role != 'user'){
                $userInfo= User::where('id', Auth::id())->whereIn('role', ['super_admin', 'admin', 'sub_admin'])->first();
                if (!is_file(public_path($userInfo->photo))) {
                    $userInfo->photo= 'uploads/avatar.png';
                }

                // Get Modules Current User can access
                if (in_array($userInfo->role, ['super_admin', 'admin']) || $userInfo->admin_token) {
                    $userInfo->modules = Module::where('deleted_at', null)->cursor();
                }

                if ($userInfo->role == 'sub_admin') {
                    $userInfo->modules = Module::where('deleted_at', null)
                        ->join('user_modules as um', 'um.module_id', 'modules.id')
                        ->where('um.user_id', $userInfo->id)
                        ->select(['modules.*', 'um.*'])->cursor();
                }

            }
            $view->with('currentUserInfo', $userInfo);

            // Share meta for modules instead of language files
            if (Schema::hasTable('modules')){

                if (preg_match('/admin/', URL::current())){
                    $path = explode('.', Route::currentRouteName());
                    if (preg_match('/_/', $path[0])){
                        $path = explode('_', $path[0]);
                        $path = $path[0].ucfirst($path[0]);
                    } else {
                        $path = $path[0];
                    }

                    $module = Module::where('path', $path)->pluck('meta')->toArray();
                    $meta = array_first($module);
                    static::$meta = $meta;
                    $view->with('meta', $meta);
                }
            }

        });

        // Email configuration Got from settings

        if (Schema::hasTable('settings')){
            $settings = Setting::cursor();
//            view()->share(['logo' => array_key_exists('website_logo', settings()) ? settings('website_logo') : 'assets/web/images/logo.png' ]);

            if(count($settings) > 0){
                foreach ($settings as $setting) {
                    $settings->{$setting['key']} = $setting['value'];
                }

                Config::set('app.name', $settings->website_name_ar);
                Config::set('mail.name', $settings->website_name_ar);
//                Config::set('mail.driver',$settings->mail_driver);
//                Config::set('mail.host',$settings->mail_host);
//                Config::set('mail.port',$settings->mail_port);
//                Config::set('mail.username',$settings->mail_username);
//                Config::set('mail.password',$settings->mail_password);
                Config::set('mail.from', [
                    'address' => $settings->mail_from_address,
                    'name' => $settings->mail_from_name,
                ]);

            }

            $logo = $settings->where('key', 'website_logo')->first();
            if ($logo){
                view()->share('logo', $logo->value);
            }
        }



    }
}
