<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Slider
 * @package App
 * @mixin Builder
 */
class Slider extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'show_in',
        'image',
    ];


    public static function withDescription($ids = [])
    {
        $query = self::join('slider_descriptions as sliderDesc', 'sliderDesc.slider_id', 'sliders.id')
            ->where('sliderDesc.language_id', currentLanguage()->id);

        if (count($ids)){
            $query->whereIn('sliders.id', $ids);
        }

        $query->select(['sliderDesc.title',  'sliderDesc.description']);

        return count($ids) == 1 ? $query->first() : $query->first();
    }

}
