<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\Video;
use App\Language;
use App\VideoDescription;
use Faker\Generator as Faker;

$factory->define(VideoDescription::class, function (Faker $faker) {
    return [
        'title' => $faker->name,
        'video_id' => factory(Video::class)->create()->id,
        'language_id' => Language::firstOrCreate(['local'=> getCurrentLocale(), 'name'=> \LaravelLocalization::getCurrentLocaleName()])->id,
    ];
});


