<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateArticleDescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('title', 100)->nullable();
            $table->longText('description')->nullable();
//            $table->string('slug',100)->nullable();
//            $table->text('meta_description')->nullable();
//            $table->string('keywords',400)->nullable();

            $table->unsignedBigInteger('article_id')->index();
            $table->unsignedBigInteger('language_id')->index();
            $table->foreign('article_id')->references('id')->on('articles')->cascadeOnDelete();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_descriptions');
    }
}
