<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePhotoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('photos', function (Blueprint $table) {
            $table->id();
            $table->string('image', 200);
            $table->unsignedBigInteger('photo_category_id')->index();

            $table->foreign('photo_category_id')->references('id')->on('photo_categories')->cascadeOnDelete();

            $table->softDeletes();
            $table->timestamps();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('photos');
    }
}
