<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCareerApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('career_applications', function (Blueprint $table) {
            $table->id();

            $table->string('name', 100);
            $table->unsignedBigInteger('career_id')->index();
            $table->unsignedBigInteger('country_id')->index();
            $table->unsignedBigInteger('education_id')->index();
            $table->unsignedBigInteger('service_id')->index();
//            $table->date('submission_date')->nullable();
            $table->string('phone', 15);
            $table->date('birth_date');
            $table->string('address', 100);
            $table->string('cv', 200);

//            $table->foreign('career_id')->references('id')->on('careers')->cascadeOnDelete();

            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('career_applications');
    }
}
