<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGalleryDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gallery_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('title', 100)->nullable();

            $table->unsignedBigInteger('gallery_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('gallery_id')->references('id')->on('galleries')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gallery_descriptions');
    }
}
