<?php

use App\Article;
use App\ArticleDescription;
use Illuminate\Database\Seeder;

class FlavorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/flavors-1.png',
            'assets/web/images/flavors-2.png',
            'assets/web/images/flavors-3.png',
            'assets/web/images/flavors-4.png',
            'assets/web/images/flavors-5.png',
            'assets/web/images/flavors-6.png',
        ];

        foreach ($images as $image) {
            factory(Article::class)->create(['image' => $image]);
        }

        foreach (languages() as $language){
            factory(ArticleDescription::class)->create([
                'name' => 'Mangoholic',
                'description' => 'Natural mangos puree, water and sugar mangos puree, water and sugar',
                'article_id' => 1,
                'language_id' => $language->id,
            ]);
            factory(ArticleDescription::class)->create([
                'name' => 'Berries Bliss',
                'description' => 'Natural mangos puree, water and sugar mangos puree, water and sugar',
                'article_id' => 2,
                'language_id' => $language->id,
            ]);
            factory(ArticleDescription::class)->create([
                'name' => 'Mark’s Lemon Punch',
                'description' => 'Natural mangos puree, water and sugar mangos puree, water and sugar',
                'article_id' => 3,
                'language_id' => $language->id,
            ]);
            factory(ArticleDescription::class)->create([
                'name' => 'Berries Bliss',
                'description' => 'Natural mangos puree, water and sugar mangos puree, water and sugar',
                'article_id' => 4,
                'language_id' => $language->id,
            ]);
            factory(ArticleDescription::class)->create([
                'name' => 'Mangoholic',
                'description' => 'Natural mangos puree, water and sugar mangos puree, water and sugar',
                'article_id' => 5,
                'language_id' => $language->id,
            ]);
            factory(ArticleDescription::class)->create([
                'name' => 'Mark’s Punch',
                'description' => 'Natural mangos puree, water and sugar mangos puree, water and sugar',
                'article_id' => 6,
                'language_id' => $language->id,
            ]);

        }
    }

}
