<?php

use Illuminate\Database\Seeder;

class GallerySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $image = 'assets/web/images/news-2.jpg';
        $file = 'assets/admin/images/605e619417c0e.pdf';

        factory(\App\Gallery::class, 7)->create(['type' => 'image_type', 'image' => $image]);
        factory(\App\Gallery::class, 7)->create(['type' => 'video_type', 'image' => $image, 'video_url' => 'https://www.youtube.com/watch?v=h0pEL8GklCc']);
        factory(\App\Gallery::class, 4)->create(['type' => 'magazine_type', 'image' => $image]);
        factory(\App\Gallery::class, 3)->create(['type' => 'magazine_type', 'image' => $file]);

        foreach (languages() as $language) {
            foreach (\App\Gallery::cursor() as $gallery) {
                factory(\App\GalleryDescription::class)->create([
                    'gallery_id' => $gallery->id,
                    'language_id' => $language->id,
                ]);
            }
        }

    }
}
