<?php

use Illuminate\Database\Seeder;

class ReviewSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $reviews = factory(\App\Review::class, 7)->create();

        foreach (languages() as $language) {
            foreach ($reviews as $review) {
                factory(\App\ReviewDescription::class)->create([
                    'review_id' => $review->id,
                    'language_id' => $language->id,
                ]);
            }
        }
    }
}
