@foreach($directors as $key=> $row)
<tr>
    <th scope="row">
        <div class="custom-control custom-checkbox">
            <input type="checkbox" class="custom-control-input selectOne deleteCheck" id="customCheck{{$row->id}}" value="{{$row->id}}" name="id[]">
            <label class="custom-control-label" for="customCheck{{$row->id}}"></label>
        </div>
    </th>
    <td>{{ $row->name }}</td>
    <td>{{ $row->specialist }}</td>
    <td colspan="2">{{ \Carbon\Carbon::parse($row->created_at)->format('Y/m/d') }}</td>
    <td>
        <div class="dropdown">
            <button class="icon_dots dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-expanded="false">
                <i class="bi bi-three-dots-vertical"></i>
            </button>
            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                @if($row->deleted_at)
                    <a class="dropdown-item rowAction"  href="{{ route ('directors.restore', $row->id) }}" data-method="put" title="{{ __('dashboard.restore') }}"> <i class="bi bi-arrow-clockwise ml-1"></i> {{ __('dashboard.restore') }} </a>
                    <a class="dropdown-item rowAction" href="{{ route ('directors.destroy', $row->id) }}" data-method="delete" title="{{ __('dashboard.delete') }}"> <i class="bi bi-trash ml-1"></i> {{ __('dashboard.delete') }} </a>
                @else
                    <a class="dropdown-item" href="{{ route ('directors.edit', $row->id) }}" title="{{ __('dashboard.edit') }}"> <i class="bi bi-pen ml-1"></i> {{ __('dashboard.edit') }} </a>
                    <a class="dropdown-item rowAction"  href="{{ route ('directors.destroy', $row->id) }}" data-method="delete" title="{{ __('dashboard.trash') }}"> <i class="bi bi-trash ml-1"></i> {{ __('dashboard.trash') }} </a>
                @endif
            </div>
        </div>
        <!--@if($row->deleted_at)-->
        <!--    <a href="{{ route ('directors.restore', $row->id) }}" data-method="put" class="icon rowAction" title="{{ __('dashboard.restore') }}">-->
        <!--        <img src="{{ asset('assets/admin/images/icons/restore.svg') }}" alt="{{ __('dashboard.restore') }}">-->
        <!--        </a>-->

        <!--    <a href="{{ route ('directors.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.delete') }}"><img src="{{ asset('assets/admin/images/icons/close.svg') }}" alt="{{ __('dashboard.delete') }}"></a>-->
        <!--@else-->
        <!--    <a href="{{ route ('directors.edit', $row->id) }}" class="icon" title="{{ __('dashboard.edit') }}"><img src="{{ asset('assets/admin/images/icons/draw.svg') }}" alt="{{ __('dashboard.edit') }}"></a>-->

        <!--    <a href="{{ route ('directors.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.trash') }}"><img src="{{ asset('assets/admin/images/icons/del.svg') }}" alt="{{ __('dashboard.trash') }}"></a>-->
        <!--@endif-->
    </td>
</tr>
@endforeach

@if( count( $directors ) )
<tr> <td></td><td> {{ $directors->links() }} </td> </tr>
@endif

