@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_doctor_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($doctor ?? ''  && $doctor->id)
            @method('PUT')
        @endif
        @csrf

            <div class="form-group col-lg-6">
                <label>{{ meta('facebook', $lang) ?? __('doctors.facebook') }} </label>
                <input type="url" class="form-control {{ $errors->has('facebook') ? 'is-invalid' : '' }}" name="facebook" placeholder="{{ meta('facebook', $lang) ?? __('doctors.facebook') }}" value='{{ old("facebook", $doctor->facebook ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('twitter', $lang) ?? __('doctors.twitter') }} </label>
                <input type="url" class="form-control {{ $errors->has('twitter') ? 'is-invalid' : '' }}" name="twitter" placeholder="{{ meta('twitter', $lang) ?? __('doctors.twitter') }}" value='{{ old("twitter", $doctor->twitter ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('instagram', $lang) ?? __('doctors.instagram') }} </label>
                <input type="url" class="form-control {{ $errors->has('instagram') ? 'is-invalid' : '' }}" name="instagram" placeholder="{{ meta('instagram', $lang) ?? __('doctors.instagram') }}" value='{{ old("instagram", $doctor->instagram ?? "") }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('linkedin', $lang) ?? __('doctors.linkedin') }} </label>
                <input type="url" class="form-control {{ $errors->has('linkedin') ? 'is-invalid' : '' }}" name="linkedin" placeholder="{{ meta('linkedin', $lang) ?? __('doctors.linkedin') }}" value='{{ old("linkedin", $doctor->linkedin ?? "") }}'/>
            </div>


            @foreach(languages() as $language)
                <div class="form-group col-lg-12">
                    <label>{{ meta('name', $language->local) ?? __('doctors.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('doctors.name') }}" value='{{ old("name_{$language->local}", $doctor[$language->local]->name ?? "") }}'/>
                </div>
                <div class="form-group col-lg-12">
                    <label>{{ meta('specialist', $language->local) ?? __('doctors.specialist')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="specialist_{{ $language->local }}" class="form-control {{ $errors->has('specialist_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('specialist', $language->local) ?? __('doctors.specialist')}}">{{ old("specialist_{$language->local}", $doctor[$language->local]->specialist ?? "") }}</textarea>
                </div>
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('certifications', $language->local) ?? __('doctors.certifications')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="certifications_{{ $language->local }}" class="form-control {{ $errors->has('certifications_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('certifications', $language->local) ?? __('doctors.certifications')}}">{{ old("certifications_{$language->local}", $doctor[$language->local]->certifications ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('trainings', $language->local) ?? __('doctors.trainings')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="trainings_{{ $language->local }}" class="form-control {{ $errors->has('trainings_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('trainings', $language->local) ?? __('doctors.trainings')}}">{{ old("trainings_{$language->local}", $doctor[$language->local]->trainings ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('experiences', $language->local) ?? __('doctors.experiences')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="experiences_{{ $language->local }}" class="form-control {{ $errors->has('experiences_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('experiences', $language->local) ?? __('doctors.experiences')}}">{{ old("experiences_{$language->local}", $doctor[$language->local]->experiences ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('researches', $language->local) ?? __('doctors.researches')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="researches_{{ $language->local }}" class="form-control {{ $errors->has('researches_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('researches', $language->local) ?? __('doctors.researches')}}">{{ old("researches_{$language->local}", $doctor[$language->local]->researches ?? "") }}</textarea>--}}
{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <label>{{ meta('professional_memberships', $language->local) ?? __('doctors.professional_memberships')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--                    <textarea rows="5" name="professional_memberships_{{ $language->local }}" class="form-control {{ $errors->has('professional_memberships_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('professional_memberships', $language->local) ?? __('doctors.professional_memberships')}}">{{ old("professional_memberships_{$language->local}", $doctor[$language->local]->professional_memberships ?? "") }}</textarea>--}}
{{--                </div>--}}
                <div class="form-group col-lg-12">
                    <label>{{ meta('details', $language->local) ?? __('doctors.details')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="details_{{ $language->local }}" class="form-control {{ $errors->has('details_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('details', $language->local) ?? __('doctors.details')}}">{{ old("details_{$language->local}", $doctor[$language->local]->details ?? "") }}</textarea>
                </div>
            @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12 image_container">
                <label>{{ meta('image', $lang) ?? __('doctors.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $doctor->image ?? "")}}"/>

                <div class="photos main_photo {{ old('image', $doctor->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $doctor->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $doctor->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
            </div>
            {{--End image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn add_doctor_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_doctor_button', '.add_doctor_form')
    </script>

@endsection



