@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? ''}}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        <input type="hidden" name="user_id" value="{{auth()->id()}}">
        @if($gallery ?? ''  && $gallery->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-12">
            <label>{{ meta('type', $lang) ?? __('galleries.type') }} </label>
            <select name="type" class="form-control {{ $errors->has('type') ? 'is-invalid' : '' }}">
                <option {{old('type', $gallery->type ?? null) == 'image_type' ? 'selected' : '' }} value="image_type">{{__('galleries.image_type')}}</option>
                <option {{old('type', $gallery->type ?? null) == 'video_type' ? 'selected' : '' }} value="video_type">{{__('galleries.video_type')}}</option>
                <option {{old('type', $gallery->type ?? null) == 'magazine_type' ? 'selected' : '' }} value="magazine_type">{{__('galleries.magazine_type')}}</option>
            </select>
        </div>

        <div class="form-group video_url col-lg-12 {{($gallery->video_url ?? null) ? '' : 'd-none'}}">
            <label>{{ meta('video_url', $lang) ?? __('galleries.video_url') }} </label>
            <input type="url" class="form-control {{ $errors->has('video_url') ? 'is-invalid' : '' }}" name="video_url" placeholder="{{ meta('video_url', $lang) ?? __('galleries.video_url') }}" value='{{ old("video_url", $gallery->video_url ?? "") }}'/>
        </div>

        @foreach(languages() as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('title', $language->local) ?? __('galleries.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('galleries.title') }}" value='{{ old("title_{$language->local}", $gallery[$language->local]->title ?? "") }}'/>
        </div>
        @endforeach

        {{--Start image container--}}
        <div class="form-group col-lg-12 image_container">
            <label>{{ meta('image', $lang) ?? __('doctors.image') }}
                <br> <span class="text-danger">{{__('galleries.image_file_types')}}</span>
            </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $gallery->image ?? "")}}"/>

            <div class="photos main_photo {{ old('image', $gallery->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-md-4">
                    <div class="items">
                        <div class="img">
                            @if(strpos(($gallery->image ?? null), '.pdf'))
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', 'assets/admin/images/file-icon.png'))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            @else
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $gallery->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            @endif

                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $gallery->image ?? '') ? 'hide' : '' }}">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm lfm_file btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
        </div>
        {{--End image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
        let imgSrc = "{{asset('assets/admin/images/file-icon.png')}}";
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script>
        sendAjax('.add_button', '.add_form');



        $('select[name="type"]').change(function(){
            if($(this).val() === 'video_type'){
                $('.video_url').removeClass('d-none');
            } else {
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val('');
            }
        });



    </script>
@endsection



