@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>
<div class="border-item">
    <form class="form-row save_data_form" method="post" action="{{ $action }}">
{{--        <input type="hidden" name="photo_category_id" value="{{$photoCategory->id}}">--}}
        @if($photoCategory ?? ''  && $photoCategory->id ?? '')
            @method('PUT')
        @endif
        @CSRF
        <div class="side-title col-md-12">
            <div class="row">
                <div class="col-lg-3">
                    <h3>{{meta('gallery_title', $lang) ?? 'gallery title'}}</h3>
                </div>
                <div class="col-lg-3 valign">
                    <div class="add-title w-100">
                        <div class="form-group">
                            <input type="text" class="form-control {{ $errors->has('name_'.$lang) ? 'is-invalid' : '' }}" name="name_{{ $lang }}" placeholder="{{ meta('name', $lang) ?? __('photoCategories.name') }}" value='{{ old("name_".$lang, $photoCategory ?? '' ? descriptions($photoCategory)->name : "") }}'/>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 valign">
                    <div class="add-title w-100">
                        <div class="form-group">
                            <input type="text" class="form-control {{ $errors->has('slug_'.$lang) ? 'is-invalid' : '' }}" name="slug_{{ $lang }}" placeholder="{{ meta('slug', $lang) ?? __('photoCategories.slug') }}" value='{{ old("slug_".$lang, $photoCategory ?? '' ? descriptions($photoCategory)->slug : "") }}'/>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 valign">
                    <div class="edit-buttons text-right w-100">
                        <button type="submit" class="butn bg-success save_data_button">{{ __('dashboard.save') }}</button>
                        <button type="reset" class="butn btn-primary">reset</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="border-item photos col-md-12">
            <div class="row">
                @if ($photoCategory ?? false)
                    @foreach ($photoCategory['photos'] as $photo)
                        <div class="col-lg-4">
                            <div class="items">
                                <div class="img">
                                    <a href="{{ asset($photo->image ?? '')}}" data-fancybox="gallery"><img src="{{ asset($photo->image ?? '')}}" alt=""></a>
                                </div>
                                <input type="hidden" name="images[]" value="{{ $photo->image ?? "" }}">
{{--                                <div class="info">--}}
{{--                                    <div class="img-title">--}}
{{--                                        <input type="text" name="image_title_{{$lang}}[]"  placeholder="{{ meta('image_title', $lang) ?? __('photoCategories.title') }}" value="{{ descriptions($photo)->title ?? "" }}">--}}
{{--                                        <input type="hidden" name="images[]" value="{{ $photo->image ?? "" }}">--}}
{{--                                        <span class="preview"> </span>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
                                <a href="#" class="close"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="text-center">
                <input id="image_thumbnail" class="image_thumbnail" type="hidden"/>
                <div class="clearfix"></div>
                <span class="pick_button" id="add">
                    <a id="lfm" data-cache="photo_gallery" data-title="false" data-url="" data-width="" data-input=".image_thumbnail" data-preview=".image_holder" data-show="" data-hide="" class="lfm add">
                        {{__('dashboard.add_new_item')}}
                    </a>
                </span>
            </div>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imageTitle = "{{meta('image_title', $lang) ?? null}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/photos.js') }}"></script>

    <script>
        sendAjax('.save_data_button', '.save_data_form')
    </script>
@endsection
