@extends('web.layouts.container')

@section('content')
    <section class="jobs-pg section bg-babyBlue">
        <div class="container">
            <h1 class="pg_title color-dark fw-bold mb-5 wow left_to_right_apperance">
                {{$pageTitle1}} <span class="color-secondary"> {{$pageTitle2}}</span>
            </h1>

            @if(count($jobs))
                @foreach($jobs as $job)
                    <div class="job_card bg-white wow fadeInUp">
                        <div class="head in-flex">
                            <div class="content align-items-center d-flex">
                                <img src="{{asset($job->image)}}" alt="" class="sm_img"/>
                                <div class="data">
                                    <h4 class="title color-dark">{{$job->name}}</h4>
                                    <p class="categ mb-0">{{$job->service_name}}y</p>
                                    <p class="date mb-0"><i class="fa-regular fa-calendar me-2 color-dark opacity-50"></i> {{date('d M Y', strtotime($job->created_at))}}</p>
                                </div>
                            </div>
                            <a href="{{route('career.applyFrom', $job->id)}}" class="butn primary_butn text-capitalize">{{__('main.apply_now')}}</a>
                        </div>
                        <p class="det mb-0 mt-4">
                            <small>{{$job->description}}</small>
                        </p>
                    </div>
                @endforeach
            @endif
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
