@extends('web.layouts.container')

@section('content')
    <section class="ceo-pg conference_det section bg-babyBlue">
        <div class="container">
            <img src="{{asset($conference->image)}}" alt="" class="sec-img wow left_to_right_apperance"/>
            <div class="card-body col-lg-10 m-auto wow left_to_right_apperance">
                <h2 class="fw-bold color-dark mb-4">{{$conference->currentDescription->title}}</h2>
                <div class="dateTime d-flex">
                    <p class="date me-5">
                        <i class="bi bi-calendar4-week me-2 color-dark"></i> {{date('d M Y ', strtotime($conference->created_at))}}
                    </p>
                    <p class="date me-5">
                        <i class="bi bi-calendar4-week me-2 color-dark"></i> {{date('h:i A', strtotime($conference->created_at))}}
                    </p>
                </div>
                <div class="desc_container">
                    {!! $conference->currentDescription->description !!}
                </div>
            </div>
            <div class="row col-lg-10 m-auto mt-5">
                @if(is_array($conference->files) && count($conference->files))
                    @foreach($conference->files as $files)
                    <div class="col-lg-4">
                        <div class="file_card  wow fadeInUp">
                            <img src="{{asset('assets/web/images/icons/file.png')}}" alt="" class="icon"/>
                            <h5 class="title text-center color-secondary">{{__('main.file') . ' - ' . $loop->iteration}}</h5>
                            <a href="{{asset($files)}}" download class="butn white_butn">
                                <img src="{{asset('assets/web/images/icons/pdf.svg')}}" alt="" class="icon_pdf"/> {{__('main.download_file')}}
                            </a>
                        </div>
                    </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

    <script>
        $(document).ready(function () {
            $('.desc_container p').addClass('.det lh-lg')
        })
    </script>

@endsection
