@extends('web.layouts.container')

@section('content')

    <section class="contact-pg section bg-babyBlue">
        <div class="container">
            <div class="inner bg-white wow left_to_right_apperance">
                <div class="row align-items-end justify-content-between">
                    <div class="head mb-5 col-lg-12">
                        <h1 class="title mb-4 color-dark fw-bold text-capitalize">{{$contactUsTitle1}} <br> <span class="color-primary">{{$contactUsTitle2}}</span></h1>
                        <p class="det">{!! $contactUsPage->description !!}</p>
                    </div>
                </div>
                <div class="row">
                    @if($settings['site_phone'] ?? null)
                    <div class="col-lg-4">
                        <div class="contact_card inFlex mb-3">
                            <div class="icon_outer">
                                <img src="{{asset('assets/web/images/icons/contact-1.svg')}}" alt="" class="icon"/>
                            </div>
                            <div class="content">
                                <h5 class="title">{{__('settings.site_phone')}}</h5>
                                <p class="p mb-0">{{$settings['site_phone']}}</p>
                            </div>
                        </div>
                    </div>
                    @endif
                    @if($settings['site_email'] ?? null)
                    <div class="col-lg-4">
                        <div class="contact_card inFlex mb-3">
                            <div class="icon_outer">
                                <img src="{{asset('assets/web/images/icons/contact-2.svg')}}" alt="" class="icon"/>
                            </div>
                            <div class="content">
                                <h5 class="title">{{__('settings.site_email')}}</h5>
                                <p class="p mb-0">{{$settings['site_email']}}</p>
                            </div>
                        </div>
                    </div>
                    @endif
                    @if($settings['site_address_'.$lang] ?? null)
                    <div class="col-lg-4">
                        <div class="contact_card inFlex mb-3">
                            <div class="icon_outer">
                                <img src="{{asset('assets/web/images/icons/contact-3.svg')}}" alt="" class="icon"/>
                            </div>
                            <div class="content">
                                <h5 class="title">{{__('settings.site_address')}}</h5>
                                <p class="p mb-0">{{$settings['site_address_'.$lang]}}</p>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </section>
    <!-- Start contact-sec -->
    <section class="contact-sec section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="sec-head mb-5 wow fadeInUp">
                        <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                            {{$aboutUsTitle1}} <br> <span class="color-primary">{{$aboutUsTitle2}}</span>
                        </h1>
                        <div class="desc_container">
                            {!! $aboutUsPage->description !!}
                        </div>
                        <div class="hours-box mt-5">
                            <h5 class="title color-dark mb-4"><b>{{__('workHours.head')}}</b></h5>
                            <div class="row">
                                <div class="col-6">
                                    @foreach($workHours as $workHour)
                                        <div class="day_item">
                                            <span class="day">{{__('workHours.'.$workHour['week_day'])}}</span> :
                                            @if($workHour['status'] == 'open')
                                                <span class="time">{{date('h A', strtotime($workHour['time_from'])) .' - '. date('h A', strtotime($workHour['time_to']))}}</span>
                                            @endif
                                            @if($workHour['status'] == 'closed')
                                                <span class="time text-danger">{{__('workHours.closed')}}</span>
                                            @endif
                                        </div>
                                        @if($loop->iteration == 4) @break @endif
                                    @endforeach

                                </div>
                                <div class="col-6">
                                    @foreach($workHours as $workHour)
                                        @if($loop->iteration < 5) @continue @endif
                                        <div class="day_item">
                                            <span class="day">{{__('workHours.'.$workHour['week_day'])}}</span> :
                                            @if($workHour['status'] == 'open')
                                                <span class="time">{{date('h A', strtotime($workHour['time_from'])) .' - '. date('h A', strtotime($workHour['time_to']))}}</span>
                                            @endif
                                            @if($workHour['status'] == 'closed')
                                                <span class="time text-danger">{{__('workHours.closed')}}</span>
                                            @endif
                                        </div>

                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="map-box wow left_to_right_apperance map_container">
                        {!! $settings['site_map'] !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Start Jobs-pg -->
    <section class="jobs-det section bg-babyBlue">
        <div class="container">
            <div class="box mt-0 w-100 shadow-none wow left_to_right_apperance">
                <div class="contact-pg">
                    <div class="head mb-5 ">
                        <h1 class="title mb-4 color-dark fw-bold text-capitalize">{{$contactFormTitle1}} <span class="color-primary">{{$contactFormTitle2}}</span></h1>
                    </div>
                </div>
                <form method="post" action="{{route('contact.store')}}" class="contact_us_form">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label">{{__('visitorMessages.name')}}</label>
                                <input type="text" name="name" class="form-control" placeholder="{{__('visitorMessages.name')}}">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label">{{__('visitorMessages.email')}}</label>
                                <input type="email" name="email" class="form-control" placeholder="{{__('visitorMessages.email')}}">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label">{{__('visitorMessages.phone')}}</label>
                                <input typeof="tel" name="phone" class="form-control" placeholder="{{__('visitorMessages.phone')}}">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label">{{__('visitorMessages.subject')}}</label>
                                <input name="subject" class="form-control" placeholder="{{__('visitorMessages.subject')}}">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class="label">{{__('visitorMessages.message')}}</label>
                                <textarea name="message" class="form-control" placeholder="{{__('visitorMessages.message')}}" rows="5"></textarea>
                            </div>
                        </div>
                        <div class="col-lg-3 mt-5 m-auto">
                            <button class="butn primary_butn w-100 contact_us_button">
                                <b>{{__('main.send')}}</b>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>

@endsection

@section('inner_js')

    <script>

        $('.contact_us_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let form = $('.contact_us_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                toasterSuccess(response.message);
                $('input, textarea').val('');
            }

        });

        $(document).ready(function () {
            $('.map_container iframe').attr('width', '100%').attr('height', '550')
        })
    </script>

@endsection
