@extends('web.layouts.container')

@section('content')
    <section class="doctors-pg section bg-babyBlue">
        <div class="container">
            <h2 class="title text-center fw-bold color-dark mb-5 text-capitalize">{{$pageTitle1}} <span class="color-primary">{{$pageTitle2}}</span></h2>
            <div class="row">
                @if(count($doctors))
                    @foreach($doctors as $doctor)
                <div class="col-lg-3 col-md-6">
                    <div class="dr_card wow fadeInUp">
                        <div class="img-box">
                            <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                        </div>
                        <div class="card-body">
                            <h4 class="name mb-3">{{$doctor->name}}</h4>
                            <p class="job">Founder</p>
                            <a target="_blank" href="{{$settings['booking_appointment_url']}}" class="butn primary_butn">{{__('main.make_appointment')}}</a>
                        </div>
                    </div>
                </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
