@extends('web.layouts.container')

@section('content')
    <!-- Start partners-sec -->
    <section class="partners-sec section wow left_to_right_apperance no_scale trans_dur_4">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-2">
                    <h2 class="title fw-bold color-dark text-capitalize">{{$ourPartnerTitle1}} <span class="color-primary">{{$ourPartnerTitle2}}</span></h2>
                </div>
                <div class="col-lg-8">
                    <div class="overflow_hidden">
                        <div class="swiper-container partner-swiper">
                            <div class="swiper-wrapper">
                                @if(count($partners))
                                    @foreach($partners as $partner)
                                    <div class="swiper-slide">
                                        <img src="{{asset($partner->image)}}" alt="" class="partner_logo"/>
                                    </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Start services-sec -->
    <section class="services-sec section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="sec-head wow left_to_right_apperance no_scale">
                        <h1 class="title fw-bold color-dark mb-4 text-capitalize">
                            {{$servicePageTitle1}} <br> <span class="color-primary">{{$servicePageTitle2}}</span>
                        </h1>
                        <p class="p col-lg-11">{!! $servicePage->description !!}</p>
                    </div>
                </div>
                @if($services[0] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card bg-babyBlue wow left_to_right_apperance">
                        <img src="{{asset($services[0]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[0]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[0]['description']), 12)}} </p>
                        <a href="{{route('service.show', $services[0]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
                @if($services[1] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card wow left_to_right_apperance">
                        <img src="{{asset($services[1]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[1]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[1]['description']), 12)}} </p>
                        <a href="{{route('service.show', $services[1]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
            </div>
            <div class="row justify-content-end">
                @if($services[2] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card bg-babyBlue wow left_to_right_apperance">
                        <img src="{{asset($services[2]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[2]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[2]['description']), 12)}} </p>

                        <a href="{{route('service.show', $services[2]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
                @if($services[3] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card wow left_to_right_apperance">
                        <img src="{{asset($services[3]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[3]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[3]['description']), 12)}} </p>
                        <a href="{{route('service.show', $services[3]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
                @if($services[4] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card bg-babyBlue wow left_to_right_apperance">
                        <img src="{{asset($services[4]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[4]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[4]['description']), 12)}} </p>
                        <a href="{{route('service.show', $services[4]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
            </div>
            <div class="row justify-content-start">
                @if($services[5] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card bg-babyBlue wow left_to_right_apperance">
                        <img src="{{asset($services[5]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[5]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[5]['description']), 12)}} </p>
                        <a href="{{route('service.show', $services[5]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
                @if($services[6] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card wow left_to_right_apperance">
                        <img src="{{asset($services[6]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[6]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[6]['description']), 12)}} </p>
                        <a href="{{route('service.show', $services[6]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
                @if($services[7] ?? null)
                <div class="col-lg-3 px-0">
                    <div class="service_card bg-babyBlue wow left_to_right_apperance">
                        <img src="{{asset($services[7]['image'])}}" alt="" class="icon"/>
                        <h5 class="title color-dark fw-bold">{{$services[7]['name']}}</h5>
                        <p class="det">{{wordLimit(stripText($services[7]['description']), 12)}} </p>
                        <a href="{{route('service.show', $services[7]['id'])}}" class="more_butn mt-4">
                            <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                        </a>
                    </div>
                </div>
                @endif
            </div>
        </div>
        <img src="{{asset('assets/web/images/pattern-2.png')}}" alt="" class="pattern"/>
    </section>
    <!-- Start features-sec -->
    <section class="features-sec section">
        <span class="back wow left_to_right_apperance"></span>
        <div class="container">
            <div class="row justify-content-between align-items-center">
                <div class="col-lg-5">
                    <div class="cards wow left_to_right_apperance trans_delay_4 no_scale">
                        <div class="feature_card d-flex ">
                            <img src="{{asset($whyUsCard1->image)}}" alt="" class="icon"/>
                            <div class="content">
                                <h5 class="title color-dark fw-bold">
                                    {{$whyUsCard1->title}}
                                </h5>
                                <p class="p">{!! $whyUsCard1->description !!}</p>
                            </div>
                        </div>
                        <div class="feature_card d-flex ">
                            <img src="{{asset($whyUsCard2->image)}}" alt="" class="icon"/>
                            <div class="content">
                                <h5 class="title color-dark fw-bold">
                                    {{$whyUsCard2->title}}
                                </h5>
                                <p class="p">{!! $whyUsCard2->description !!}</p>
                            </div>
                        </div>
                        <div class="feature_card d-flex ">
                            <img src="{{asset($whyUsCard3->image)}}" alt="" class="icon"/>
                            <div class="content">
                                <h5 class="title color-dark fw-bold">
                                    {{$whyUsCard3->title}}
                                </h5>
                                <p class="p">{!! $whyUsCard3->description !!}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="features_box wow left_to_right_apperance">
                        <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                            {{$numberPageTitle1}} <span class="color-primary">{{$numberPageTitle2}}</span>
                        </h1>
                        <p class="det mb-5">
                            <small>{!! $numbersPage->description !!}</small>
                        </p>
                        <div class="row">
                            <div class="col-6">
                                <div class="statics_card">
                                    <h1 class="num fw-bold color-dark"><span class="counter">{{$settings['special_num_1_value']}}</span>+</h1>
                                    <p class="label">{{$settings['special_num_1_title_'.$lang]}}</p>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="statics_card">
                                    <h1 class="num fw-bold color-dark"><span class="counter">{{$settings['special_num_2_value']}}</span>k</h1>
                                    <p class="label">{{$settings['special_num_2_title_'.$lang]}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <img src="{{asset('assets/web/images/pattern-3.png')}}" alt="" class="pattern"/>
    </section>
    <!-- Start doctors-sec -->
    <section class="doctors-sec section">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="sec-head  wow left_to_right_apperance no_scale">
                        <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                            {{$doctorPageTitle1}} <span class="color-primary">{{$doctorPageTitle2}}</span>
                        </h1>
                        <p class="p">{!! $doctorPage->description !!}</p>
                    </div>
                </div>
            </div>
            <div class="swiper-container doctor-swiper wow left_to_right_apperance">
                <div class="swiper-wrapper">
                    @if(count($doctors))
                        @foreach($doctors as $doctor)
                        <div class="swiper-slide">
                            <div class="row">
                                <div class="col-lg-7 px-0">
                                    <div class="text-box">
                                        <h3 class="name text-white mb-3">{{$doctor->name}}</h3>
                                        <h5 class="job text-white">{{$doctor->specialist}}</h5>
                                        <ul class="custom_ul mt-5 desc_container">
                                           {!! $doctor->details !!}
                                        </ul>
                                        <div class="social_links mt-5">
                                            @if($doctor->facebook)
                                                <a target="_blank" href="{{$doctor->facebook}}">
                                                    <img src="{{asset('assets/web/images/icons/social-1.svg')}}" alt="" class="icon icon-18"/>
                                                </a>
                                            @endif
                                            @if($doctor->twitter)
                                                <a target="_blank" href="{{$doctor->twitter}}">
                                                    <img src="{{asset('assets/web/images/icons/social-2.svg')}}" alt="" class="icon icon-18"/>
                                                </a>
                                            @endif
                                            @if($doctor->instagram)
                                                <a target="_blank" href="{{$doctor->instagram}}">
                                                    <img src="{{asset('assets/web/images/icons/social-3.svg')}}" alt="" class="icon icon-18"/>
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-5 px-0">
                                    <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                                </div>

                            </div>
                        </div>
                        @endforeach
                    @endif
                </div>
                <!-- pagination -->
                <div class="swiper-pagination"></div>
                <!-- Arrows -->
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
        <img src="{{asset('assets/web/images/pattern-3.png')}}" alt="" class="pattern"/>
    </section>
    <!-- Start news-sec -->
    <section class="news-sec section">
        <div class="container">
            <div class="sec-head mb-5 wow left_to_right_apperance">
                <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                    {{$newsPageTitle1}} <br> <span class="color-primary">{{$newsPageTitle2}}</span>
                </h1>
                <p class="p">{!! $newsPage->description !!}</p>
            </div>
            <div class="row">
                @if(count($articles))
                    @foreach($articles as $article)
                    <div class="col-lg-6">
                        <div class="news_card wow left_to_right_apperance">
                            <div class="row align-items-center">
                                <div class="col-md-6">
                                    <img src="{{asset($article->image)}}" alt="" class="sec-img"/>
                                </div>
                                <div class="col-md-6">
                                    <div class="content">
                                        <h4 class="title fw-bold color-dark mb-3">{{$article->title}}</h4>
                                        <p class="date mb-2">
                                            <img src="{{asset('assets/web/images/icons/date.svg')}}" alt="" class="icon icon-15 me-2"/>{{date('d M Y', strtotime($article->created_at))}}
                                        </p>
                                        <p class="det">{{wordLimit(stripText($article->description), 25)}}</p>
                                        <a href="{{route('news.show', $article->id)}}" class="more_butn color-primary fw-bold">
                                            {{__('main.read_more')}} <img src="{{asset('assets/web/images/icons/right_arrow2.svg')}}" alt="" class="icon icon-18 ms-2 filterPrimary"/>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
    <!-- Start news-sec -->
    <section class="news-pg section bg-light">
        <div class="container">
            <div class="sec-head mb-5  wow left_to_right_apperance">
                <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                    {{$conferencePageTitle1}} <br> <span class="color-primary">{{$conferencePageTitle2}}</span>
                </h1>
                <p class="p">{!! $conferencePage->description !!}</p>
            </div>
            <div class="row">
                @if(count($conferences))
                    @foreach($conferences as $conference)
                        <div class="col-lg-4">
                        <div class="news_card  wow left_to_right_apperance">
                            <img src="{{asset($conference->image)}}" alt="" class="sec-img"/>
                            <div class="content">
                                <h4 class="title fw-bold color-dark mb-3">{{$conference->title}}</h4>
                                <p class="date mb-2">
                                    <img src="{{asset('assets/web/images/icons/date.svg')}}" alt="" class="icon icon-15 me-2"/>{{date('d M Y', strtotime($conference->start_date))}}
                                </p>
                                <p class="det">{{wordLimit(stripText($conference->description), 10)}}</p>
                                <a href="{{route('conference.show', $conference->id)}}" class="more_butn color-primary fw-bold">
                                    {{__('main.read_more')}} <img src="{{asset('assets/web/images/icons/right_arrow2.svg')}}" alt="" class="icon icon-18 ms-2 filterPrimary"/>
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
    <!-- Start contact-sec -->
    <section class="contact-sec section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="sec-head mb-5 wow fadeInUp">
                        <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                            {{$aboutUsTitle1}} <br> <span class="color-primary">{{$aboutUsTitle2}}</span>
                        </h1>
                        <div class="desc_container">
                            {!! $aboutUsPage->description !!}
                        </div>
                        <div class="hours-box mt-5">
                            <h5 class="title color-dark mb-4"><b>{{__('workHours.head')}}</b></h5>
                            <div class="row">
                                <div class="col-6">
                                    @foreach($workHours as $workHour)
                                        <div class="day_item">
                                            <span class="day">{{__('workHours.'.$workHour['week_day'])}}</span> :
                                            @if($workHour['status'] == 'open')
                                                <span class="time">{{date('h A', strtotime($workHour['time_from'])) .' - '. date('h A', strtotime($workHour['time_to']))}}</span>
                                            @endif
                                            @if($workHour['status'] == 'closed')
                                                <span class="time text-danger">{{__('workHours.closed')}}</span>
                                            @endif
                                        </div>
                                        @if($loop->iteration == 4) @break @endif
                                    @endforeach

                                </div>
                                <div class="col-6">
                                    @foreach($workHours as $workHour)
                                        @if($loop->iteration < 5) @continue @endif
                                        <div class="day_item">
                                            <span class="day">{{__('workHours.'.$workHour['week_day'])}}</span> :
                                            @if($workHour['status'] == 'open')
                                                <span class="time">{{date('h A', strtotime($workHour['time_from'])) .' - '. date('h A', strtotime($workHour['time_to']))}}</span>
                                            @endif
                                            @if($workHour['status'] == 'closed')
                                                <span class="time text-danger">{{__('workHours.closed')}}</span>
                                            @endif
                                        </div>

                                    @endforeach
                                </div>
                            </div>
                            <p class="hours_note fw-bold  mt-3">
                                <i class="fa-regular fa-clock color-primary me-2"></i>
                                {{$workingHoursPage->title}}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="map-box wow left_to_right_apperance map_container">
                        {!! $settings['site_map'] !!}
                    </div>
                </div>
            </div>
            <div class="box contact_form_box wow fadeInUp">
                <h1 class="title color-dark fw-bold mb-5 text-capitalize">
                    {{$contactFormTitle1}}  <span class="color-primary">{{$contactFormTitle2}}</span>
                </h1>
                <form method="post" action="{{route('contact.store')}}" class="contact_us_form">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-4">
                                <label class="label fw-bold color-dark mb-2">{{__('visitorMessages.name')}}</label>
                                <input type="text" name="name" class="form-control" placeholder="{{__('visitorMessages.name')}}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-4">
                                <label class="label fw-bold color-dark mb-2">{{__('visitorMessages.email')}}</label>
                                <input type="email" name="email" class="form-control" placeholder="{{__('visitorMessages.email')}}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-4">
                                <label class="label fw-bold color-dark mb-2">Phone number</label>
                                <input typeof="tel" name="phone" class="form-control" placeholder="{{__('visitorMessages.phone')}}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-4">
                                <label class="label fw-bold color-dark mb-2">{{__('visitorMessages.subject')}}</label>
                                <input name="subject" class="form-control" placeholder="{{__('visitorMessages.subject')}}">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group mb-4">
                                <label class="label fw-bold color-dark mb-2">{{__('visitorMessages.message')}}</label>
                                <textarea name="message" class="form-control" placeholder="{{__('visitorMessages.message')}}" rows="5"></textarea>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <button class="butn primary_butn mt-4 contact_us_button"><b>{{__('main.send')}}</b></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
    <section class="partners-sec section wow left_to_right_apperance">
        <div class="container">
            <div class="sec-head mb-5 col-lg-5">
                <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                    {{$insurancePartnerTitle1}} <span class="color-primary">{{$insurancePartnerTitle2}}</span>
                </h1>
                <p class="p">{!! $insurancePartnerPage->description !!}</p>
            </div>
            <div class="swiper-container partner-swiper">
                <div class="swiper-wrapper">
                    @if(count($insurancePartners))
                        @foreach($insurancePartners as $insurancePartner)
                            <div class="swiper-slide">
                                <img src="{{asset($insurancePartner->image)}}" alt="" class="partner_logo"/>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>


        $('.contact_us_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let form = $('.contact_us_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                toasterSuccess(response.message);
                $('input, textarea').val('');
            }

        });


        $(document).ready(function () {
            $('.map_container iframe').attr('width', '100%').attr('height', '550')
        });

        $(document).ready(function () {
            $('.desc_container li').addClass('li');
        });
        var startingModal = new bootstrap.Modal(document.getElementById('startingModal'));
        startingModal.show();
    </script>
@endsection
