<footer class="footer section pb-0">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-lg-2">
                <div class="content">
                    <img src="{{asset('assets/web/images/logo.svg')}}" alt="" class="logo mb-4"/>
                    <p class="det">{{$settings['site_phone']}}</p>
                    <p class="det">{{$settings['site_address_'.$lang]}}</p>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="content">
                    <p class="p">{!! pages(21)->description !!}</p>
                    <div class="social_links mt-3">
                        @if($settings['facebook'] ?? null)
                            <a target="_blank" href="{{$settings['facebook']}}"><i class="fa-brands fa-facebook-f"></i></a>
                        @endif
                        @if($settings['instagram'] ?? null)
                            <a target="_blank" href="{{$settings['instagram']}}"><i class="fa-brands fa-instagram"></i></a>
                        @endif
                        @if($settings['linkedin'] ?? null)
                            <a target="_blank" href="{{$settings['linkedin']}}"><i class="fa-brands fa-linkedin-in"></i></a>
                        @endif
                        @if($settings['snapchat'] ?? null)
                            <a target="_blank" href="{{$settings['snapchat']}}"><i class="fa-brands fa-snapchat"></i></a>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-lg-2">
                <div class="content">
                    <h5 class="title color-dark fw-bold mb-4">Direct Links</h5>
                    <div class="links">
                        @if(count(specializations()))
                            @foreach(specializations() as $specialization)
                                <a href="{{route('service.show', $specialization->id)}}">{{$specialization->name}}</a>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <p class="copyright_p mb-0 py-3 mt-4 text-center">
            © Copyright {{date('Y')}} <b class="color-dark">{{__('main.copy_right_first_word')}}</b> {{__('main.copy_right_second_word')}}
        </p>
    </div>
</footer>
<!-- Start modal -->
@if($settings['show_start_pop_up'])
    <div class="modal startingModal" tabindex="1" id="startingModal">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-body">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <img src="{{asset(pages(22)->image)}}" alt="" class="sec-img"/>
                        </div>
                        <div class="col-lg-6">
                            <div class="text-box py-3">
                                <h2 class="title fw-bold color-dark mb-3">{{pages(22)->title}}</h2>
                                <p class="det">{{pages(22)->description}}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif<!--Scroll to top button-->
<div class="progress-wrap ">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102"><path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 220.587;"></path></svg>
</div>
