@extends('web.layouts.container')

@section('content')
    <section class="chairman-pg section bg-babyBlue">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 px-0">
                    <div class="text-box">
                        <div class="head wow left_to_right_apperance">
                            <h5 class="text-white mb-3 text-uppercase">{{__('main.mr')}}</h5>
                            <h1 class="text-white fw-bold mb-0">{{$pages->title}}</h1>
                        </div>
                        <div class="card-body desc_container wow left_to_right_apperance">
                           {!! $pages->description !!}
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 px-0 order_sm_1">
                    <img src="{{asset($pages->image)}}" alt="" class="sec-img wow fadeInUp"/>
                </div>
                <div class="col-lg-8 ms-auto me-5 wow fadeInUp">
                    <h5 class="bold_txt fw-bold color-dark ">{!! $pages->description_2 !!}</h5>
                </div>
            </div>
        </div>
    </section>
    <!-- Start doctors-pg -->
    <section class="doctors-pg section">
        <div class="container">
            <div class="head col-md-5 mb-5 wow left_to_right_apperance no_scale">
                <h1 class="title fw-bold color-dark">{{pages(15)->title}}</h1>
                <p class="det">{{stripText(pages(15)->description)}}</p>
            </div>
            <div class="row">
                @if(count($doctors))
                    @foreach($doctors as $doctor)
                        <div class="col-lg-3 col-md-6">
                            <div class="dr_card wow fadeInUp">
                                <div class="img-box">
                                    <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                                </div>
                                <div class="card-body">
                                    <h4 class="name mb-3">{{$doctor->name}}</h4>
                                    <p class="job">{{$doctor->specialist}}</p>
                                    <a target="_blank" href="{{$settings['booking_appointment_url']}}" class="butn primary_butn text-uppercase">{{__('main.make_appointment')}}</a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>
        $(document).ready(function () {
            $('.desc_container p').addClass('p');
        });
    </script>
@endsection
