@extends('web.layouts.container')

@section('content')
    <section class="services-sec section">
        <div class="container">
            <div class="sec-head mb-5 text-center">
                <h2 class="title fw-bold color-dark mb-4">
                    {{$pageTitle1}} <span class="color-primary">{{$pageTitle2}}</span>
                </h2>
                <p class="p col-lg-6 m-auto">{!! $page->description !!}</p>
            </div>
            <div class="row">
                @if(count($services))
                    @foreach($services as $service)
                        <div class="col-lg-3 px-0">
                            <div class="service_card bg-babyBlue wow left_to_right_apperance">
                                <img src="{{asset($service->image)}}" alt="" class="icon"/>
                                <h5 class="title color-dark fw-bold">{{$service->name}}</h5>
                                <p class="det">{{wordLimit($service->description, 6)}}</p>
                                <a href="{{route('service.show', $service->id)}}" class="more_butn mt-4">
                                    <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                                </a>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
        <img src="{{asset('assets/web/images/pattern-2.png')}}" alt="" class="pattern"/>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
