<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="<?php echo e($action); ?>">
        <?php if($newsletter ?? ''  && $newsletter->id ?? ''): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('email', getCurrentLocale()) ??  __('newsletters.send_to')); ?> </label>
            <?php if($newsletter ?? ''): ?>
                <input type="text" name="email" class="form-control bg-light" readonly value="<?php echo e($newsletter->email); ?>">
                <?php else: ?>
                <select name="email" id="email" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>">
                    <option value=""><?php echo e(meta('email', getCurrentLocale()) ??  __('newsletters.select')); ?></option>
                    <option <?php echo e(old("email") == 'all' ? 'selected': ''); ?> value="all"><?php echo e(meta('all', getCurrentLocale()) ??  __('newsletters.all')); ?></option>
                    <?php $__currentLoopData = newsletters(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php echo e(old("email", $newsletter->email ?? "") == $letter->email ? 'selected': ''); ?> value="<?php echo e($letter->email); ?>"><?php echo e($letter->email ?? ''); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            <?php endif; ?>

        </div>
        <div class="form-group col-lg-6">
            <label><?php echo e(meta('subject', getCurrentLocale()) ??  __('newsletters.subject')); ?></label>
            <input type="text" class="form-control <?php echo e($errors->has('subject') ? 'is-invalid' : ''); ?>" name="subject" placeholder="<?php echo e(meta('subject', getCurrentLocale()) ??  __('newsletters.subject')); ?>" value='<?php echo e(old("subject", $newsletter->subject ?? "")); ?>'/>
        </div>
        <div class="form-group col-lg-12">
            <label><?php echo e(meta('message', getCurrentLocale()) ??  __('newsletters.message')); ?></label>
            <textarea name="message" class="form-control my-editor <?php echo e($errors->has('message') ? 'is-invalid' : ''); ?> my-editor" placeholder="<?php echo e(meta('message', getCurrentLocale()) ??  __('newsletters.message')); ?>"><?php echo e(old("message", $newsletter->message ?? "")); ?></textarea>
        </div>

            <div class="form-group col-lg-12">
                <label><?php echo e(meta('categories', getCurrentLocale()) ??  __('newsletters.categories')); ?> </label>
                <div class="card p-1">
                    <div class="d-flex flex-wrap p-2">
                        <?php $__currentLoopData = articleCategories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-sm-6 col-md-4 col-lg-3 custom-control custom-checkbox">
                                <input <?php echo e(in_array($category->id, old('categories') ?? []) ? 'checked' : ''); ?> type="checkbox" id="<?php echo e('category_'.$key); ?>" class="custom-control-input" name="categories[]" value="<?php echo e($category->id); ?>" >
                                <label for="<?php echo e('category_'.$key); ?>" class="custom-control-label"><?php echo e(descriptions($category)->name); ?> </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>

        <div class="text-center mt-5 col-12">
            <button class="butn"><span><?php echo e(__('dashboard.send')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->

        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <script>
        var route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>";
        var url = "<?php echo e(asset('')); ?>/";
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\cms\resources\views/admin/newsletters/form.blade.php ENDPATH**/ ?>